/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import org.mule.devkit.apt.AbstractAnnotationProcessor;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PluginScanner;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.Verifier;
import org.mule.devkit.generation.extension.ExtensionGenerator;
import org.mule.devkit.generation.extension.connection.ConnectionProviderGenerator;
import org.mule.devkit.generation.extension.connection.OnExceptionHandlerGenerator;
import org.mule.devkit.generation.extension.metadata.MetadataInputResolverGenerator;
import org.mule.devkit.generation.extension.metadata.MetadataKeyResolverGenerator;
import org.mule.devkit.generation.extension.metadata.MetadataOperationGenerator;
import org.mule.devkit.generation.extension.metadata.MetadataOutputResolverGenerator;
import org.mule.devkit.generation.extension.metadata.MetadataResolverGenerator;
import org.mule.devkit.generation.extension.operation.OperationsGenerator;
import org.mule.devkit.generation.extension.source.SourcesGenerator;

@SupportedAnnotationTypes(value={"org.mule.api.annotations.Connector", "org.mule.api.annotations.MetaDataCategory", "org.mule.api.annotations.components.*", "org.mule.api.annotations.oauth.OAuth2"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"enabledStudioPluginPackage", "mavenInformationFile", "verboseEnabled"})
public class AnnotationProcessor
extends AbstractAnnotationProcessor {
    private Map<Verifier, Plugin> generatorPluginMap = new HashMap<Verifier, Plugin>();
    private List<Plugin> plugins;

    @Override
    protected Plugin getPluginFromVerifier(Verifier verifier) {
        return this.generatorPluginMap.get(verifier);
    }

    @Override
    public List<? extends Verifier> getAnnotationVerifiers() {
        ArrayList verifiers = new ArrayList();
        try {
            List<Plugin> plugins = this.getAllPlugins();
            for (Plugin p : plugins) {
                if (this.shouldBeIncluded(p)) {
                    verifiers.addAll(p.getVerifiers());
                    for (Verifier verifier : p.getVerifiers()) {
                        this.generatorPluginMap.put(verifier, p);
                    }
                    continue;
                }
                if (p.getOptionName() == null) continue;
                this.context.debug("The following annotation verifiers are being SKIPPED because the option \"" + p.getOptionName() + "\" is not specified:");
                for (Verifier verifier : p.getVerifiers()) {
                    this.context.debug("    " + verifier.getClass().getName());
                }
            }
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getLocalizedMessage());
        }
        return verifiers;
    }

    private List<Plugin> getAllPlugins() throws MalformedURLException {
        if (this.plugins == null) {
            this.plugins = PluginScanner.getInstance().getAllPlugins((ClassLoader)this.getUserClassLoader(this.getClass().getClassLoader()));
        }
        return this.plugins;
    }

    protected boolean shouldBeIncluded(Plugin p) {
        return p.getOptionName() == null || this.processingEnv.getOptions().get(p.getOptionName()) != null && this.processingEnv.getOptions().get(p.getOptionName()).equals("true");
    }

    @Override
    public List<Generator> getGenerators() {
        ArrayList<Generator> moduleGenerators = new ArrayList<Generator>();
        moduleGenerators.add((Generator)new ExtensionGenerator());
        moduleGenerators.add((Generator)new OperationsGenerator());
        moduleGenerators.add((Generator)new SourcesGenerator());
        moduleGenerators.add((Generator)new OnExceptionHandlerGenerator());
        moduleGenerators.add((Generator)new ConnectionProviderGenerator());
        moduleGenerators.add((Generator)new MetadataResolverGenerator());
        moduleGenerators.add((Generator)new MetadataKeyResolverGenerator());
        moduleGenerators.add((Generator)new MetadataInputResolverGenerator());
        moduleGenerators.add((Generator)new MetadataOutputResolverGenerator());
        moduleGenerators.add((Generator)new MetadataOperationGenerator());
        return moduleGenerators;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        ArrayList<PostProcessor> modulePostProcessors = new ArrayList<PostProcessor>();
        try {
            List<Plugin> plugins = this.getAllPlugins();
            for (Plugin p : plugins) {
                if (this.shouldBeIncluded(p)) {
                    modulePostProcessors.addAll(p.getPostProcessors());
                    continue;
                }
                if (p.getOptionName() == null) continue;
                this.context.debug("The following post processors are being SKIPPED because the option \"" + p.getOptionName() + "\" is not specified:");
                for (PostProcessor postProcessor : p.getPostProcessors()) {
                    this.context.debug("    " + postProcessor.getClass().getName());
                }
            }
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getLocalizedMessage());
        }
        return modulePostProcessors;
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (PluginScanner.getInstance() != null) {
            PluginScanner.getInstance().dispose();
        }
    }

    public URLClassLoader getUserClassLoader(ClassLoader parent) throws MalformedURLException {
        ArrayList<URL> classpaths = new ArrayList<URL>();
        for (Map.Entry<String, String> me : this.processingEnv.getOptions().entrySet()) {
            String key = me.getKey();
            if (!key.equals("-classpath") && !key.equals("-cp")) continue;
            for (String p : me.getValue().split(File.pathSeparator)) {
                File file = new File(p);
                classpaths.add(file.toURL());
            }
        }
        return new URLClassLoader(classpaths.toArray(new URL[classpaths.size()]), parent);
    }
}

