/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.internal.ws.common;

import com.google.common.base.Optional;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.transport.WsdlTransport;

import java.net.URL;
import java.util.List;

public interface EnhancedServiceDefinition {

    String getId();

    URL getWsdlUrl();

    String getService();

    String getPort();

    String getServiceAddress();

    List<WsdlSecurityStrategy> getStrategies();

    Optional<WsdlTransport> getTransport();

    String getOperation();
}
