package org.mule.devkit.shade.metadata;


import org.mule.common.metadata.*;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;

import java.util.List;


/**
 * Placeholder of generic methods to reduce generated code
 */
public class MetaDataGeneratorUtils {

    /**
     * This method will create a new {@link MetaData} where:
     * <ol>
     *     <li>the inner {@link MetaDataModel} will be the {@code wrappedMetaDataModel} object</li>
     *     <li>the properties from {@code userDefinedMetaData} (coded by the connector's developer) will be copied into the newly created {@link MetaData}</li>
     * </ol>
     *
     * @param wrappedMetaDataModel object generated by DevKit, see {@link org.mule.devkit.generation.mule.MessageProcessorGenerator#foldMetaData(GenericType,GeneratedVariable,ProcessorMethod)}
     * @param userDefinedMetaData metaData object created by the connector's developer to extract and copy its properties
     * @return
     */
    public static MetaData extractPropertiesToMetaData(MetaDataModel wrappedMetaDataModel, MetaData userDefinedMetaData){
        MetaData generatedMetaData = new DefaultMetaData(wrappedMetaDataModel);

        //looping through all the possible scopes:  FLOW, INBOUND, OUTBOUND, SESSION, RECORD
        for (MetaDataPropertyScope metaDataPropertyScope : MetaDataPropertyScope.values()) {
            MetaDataProperties properties = userDefinedMetaData.getProperties(metaDataPropertyScope);

            //for a given scope, we copy it to the new MetaData object
            for (MetaDataField metaDataField : properties.getFields()) {
                List<MetaDataFieldProperty> userDefinedProperties = metaDataField.getProperties();
                MetaDataFieldProperty[] arrayOfUserDefinedProperties = userDefinedProperties.toArray(new MetaDataFieldProperty[userDefinedProperties.size()]);
                generatedMetaData.addProperty(metaDataPropertyScope, metaDataField.getName(), metaDataField.getMetaDataModel(), arrayOfUserDefinedProperties);
            }
        }
        
        return generatedMetaData;

    }
}
