package org.mule.devkit.shade.connectivity;

import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;

public class ConnectivityTestingErrorHandler {

    /**
     * Helper method to be used when interacting with Studio for either of the following scenarios:
     * <ul>
     *     <li>{@link org.mule.common.Testable#test()} method, for connectivity testing</li>
     *     <li>{@link org.mule.common.metadata.ConnectorMetaDataEnabled#getMetaDataKeys()} method, when retrieving the list of keys for DataSense</li>
     * </ul>
     * @param exception
     * @return
     */
    public static DefaultResult buildFailureTestResult(Exception exception) {
        FailureType failureType = FailureType.UNSPECIFIED;
        if (exception instanceof ConnectionException) {
            ConnectionExceptionCode code = ((ConnectionException) exception).getCode();
            if (code != null) {
                switch (code) {
                    case UNKNOWN_HOST:
                        failureType = FailureType.UNKNOWN_HOST;
                        break;
                    case CANNOT_REACH:
                        failureType = FailureType.RESOURCE_UNAVAILABLE;
                        break;
                    case INCORRECT_CREDENTIALS:
                        failureType = FailureType.INVALID_CREDENTIALS;
                        break;
                    case CREDENTIALS_EXPIRED:
                        failureType = FailureType.INVALID_CREDENTIALS;
                        break;
                    case UNKNOWN:
                    default:
                        failureType = FailureType.UNSPECIFIED;
                        break;
                }
            }
        }
        return new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), failureType, exception);
    }
}
