/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.Scope;
import org.mule.devkit.generation.api.Verifier;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.studio.ConfigRequiredLibrariesVerifier;
import org.mule.devkit.generation.studio.MuleStudioContextualHelpGenerator;
import org.mule.devkit.generation.studio.MuleStudioFeatureGenerator;
import org.mule.devkit.generation.studio.MuleStudioIconsGenerator;
import org.mule.devkit.generation.studio.MuleStudioManifestGenerator;
import org.mule.devkit.generation.studio.MuleStudioPluginActivatorGenerator;
import org.mule.devkit.generation.studio.MuleStudioPluginGenerator;
import org.mule.devkit.generation.studio.MuleStudioPluginXmlGenerator;
import org.mule.devkit.generation.studio.MultiModuleStudioPackageVerifier;
import org.mule.devkit.generation.studio.SerializableArchiverPlanGenerator;
import org.mule.devkit.generation.studio.StudioSiteXmlGenerator;
import org.mule.devkit.generation.studio.editor.MuleStudioEditorXmlGenerator;
import org.mule.devkit.model.module.Module;

@RequiresMavenDependencies(value={@Dependency(groupId="org.eclipse", artifactId="eclipse-workbench", version="[3.6.1.M20100826-1330]", scope=Scope.PROVIDED), @Dependency(groupId="org.eclipse", artifactId="eclipse-runtime", version="[3.6.0.v20100505]", scope=Scope.PROVIDED), @Dependency(groupId="org.osgi", artifactId="core", version="[4.3.0]", scope=Scope.PROVIDED)})
public class MuleStudioPlugin
implements Plugin {
    private List<Verifier> verifiers;
    private List<Generator> moduleGenerators;

    public MuleStudioPlugin() {
        this.initializeGenerators();
        this.initializeVerifiers();
    }

    private void initializeGenerators() {
        this.moduleGenerators = new ArrayList<Generator>();
        this.moduleGenerators.add(new MuleStudioManifestGenerator());
        this.moduleGenerators.add(new MuleStudioEditorXmlGenerator());
        this.moduleGenerators.add(new MuleStudioPluginActivatorGenerator());
        this.moduleGenerators.add(new MuleStudioPluginXmlGenerator());
        this.moduleGenerators.add(new MuleStudioContextualHelpGenerator());
        this.moduleGenerators.add(new MuleStudioIconsGenerator());
        this.moduleGenerators.add(new MuleStudioPluginGenerator());
        this.moduleGenerators.add(new StudioSiteXmlGenerator());
        this.moduleGenerators.add(new MuleStudioFeatureGenerator());
        this.moduleGenerators.add(new SerializableArchiverPlanGenerator());
    }

    private void initializeVerifiers() {
        this.verifiers = new ArrayList<Verifier>();
        this.verifiers.add((Verifier)new ModuleAnnotationVerifier(){

            public boolean shouldVerify(Module module) {
                return true;
            }

            public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
            }
        });
        this.verifiers.add((Verifier)new MultiModuleStudioPackageVerifier());
        this.verifiers.add((Verifier)new ConfigRequiredLibrariesVerifier());
    }

    public String getOptionName() {
        return "enabledStudioPluginPackage";
    }

    public List<Verifier> getVerifiers() {
        return this.verifiers;
    }

    public List<Generator> getGenerators() {
        return this.moduleGenerators;
    }

    public List<PostProcessor> getPostProcessors() {
        return Collections.emptyList();
    }
}

