/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.verifiers.util.MulePathResolver;
import org.mule.util.IOUtils;

public class MuleStudioIconsGenerator
extends AbstractMuleStudioNamespaceGenerator {
    private ArrayList<ModuleRelativePathBuilder> iconsFileName;
    private final AcceptedFilesAsIconFilter acceptedFilesAsIconFilter = new AcceptedFilesAsIconFilter();
    private static List<Product> PRODUCES = Collections.singletonList(Product.STUDIO_ICONS);
    private static final String ICONS_NEW_FOLDER = "icons/";
    private static final String LIGHT_THEME = "theme.light";
    private static final String CLASSIC_THEME = "theme.classic";
    private static final String LIGHT_THEME_FOLDER_DEST = "icons/theme.light";
    private static final String CLASSIC_THEME_FOLDER_DEST = "icons/theme.classic";
    private static final String PNG_EXTENSION = ".png";
    private static final List<String> reservedFolderNames = Arrays.asList("theme.light", "theme.classic");

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        this.iconsFileName = new ArrayList();
        this.createCloudConnectorIcon(module);
        if (module.hasTransformers()) {
            this.createTransformerIcon(module);
        }
        if (module.hasSources()) {
            this.createSourceIcon(module);
        }
        if (this.hasContainer(module)) {
            this.createContainerIcon(module);
        }
        if (this.hasContainerList(module)) {
            this.createFlowIcon(module);
        }
        this.copyThemesFolders(module);
        this.ctx().registerProduct(Product.STUDIO_ICONS, (Identifiable)module, this.iconsFileName);
    }

    private boolean hasContainer(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainer()) continue;
            return true;
        }
        return false;
    }

    private boolean hasContainerList(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainerList()) continue;
            return true;
        }
        return false;
    }

    private void createSourceIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/theme.classic/%s-endpoint-large.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-endpoint-large.png");
        this.copyFile(String.format("../../../icons/theme.classic/%s-endpoint-small.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-endpoint-small.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-endpoint-large.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-endpoint-large.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-endpoint-small.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-endpoint-small.png");
    }

    private void createTransformerIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/theme.classic/%s-transformer-large.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-transformer-large.png");
        this.copyFile(String.format("../../../icons/theme.classic/%s-transformer-small.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-transformer-small.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-transformer-large.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-transformer-large.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-transformer-small.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-transformer-small.png");
    }

    private void createCloudConnectorIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/theme.classic/%s-connector-small.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-connector-small.png");
        this.copyFile(String.format("../../../icons/theme.classic/%s-connector-large.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-connector-large.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-connector-small.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-connector-small.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-connector-large.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-connector-large.png");
    }

    private void createContainerIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/theme.classic/%s-container-large.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-container-large.png");
        this.copyFile(String.format("../../../icons/theme.classic/%s-container-small.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-container-small.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-container-large.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-container-large.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-container-small.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-container-small.png");
    }

    private void createFlowIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/theme.classic/%s-flow-large.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-flow-large.png");
        this.copyFile(String.format("../../../icons/theme.classic/%s-flow-small.png", module.getModuleName()), CLASSIC_THEME_FOLDER_DEST, module, "theme.classic/%s-flow-small.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-flow-large.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-flow-large.png");
        this.copyFile(String.format("../../../icons/theme.light/%s-flow-small.png", module.getModuleName()), LIGHT_THEME_FOLDER_DEST, module, "theme.light/%s-flow-small.png");
    }

    private void copyFile(String fileName, String folder, Module module, String sufix) throws GenerationException {
        InputStream iconStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = this.createFile(module, folder, fileName);
            File fileToCopy = MulePathResolver.getFileResolvingPackages((Module)module, (String)fileName);
            if (fileToCopy.exists()) {
                iconStream = new FileInputStream(fileToCopy);
            } else {
                String fileIconPath = String.format(sufix, "generic");
                iconStream = MuleStudioIconsGenerator.class.getClassLoader().getResourceAsStream(fileIconPath);
            }
            IOUtils.copy((InputStream)iconStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new GenerationException("Error copying icons to output folder: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(iconStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)iconStream);
    }

    private OutputStream createFile(Module module, String folder, String fileName) throws GenerationException {
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        try {
            ModuleRelativePathBuilder pathBuilder = new ModuleRelativePathBuilder(folder + "/" + fileName);
            String fullIconPath = pathBuilder.build(module).getFullPath();
            this.iconsFileName.add(pathBuilder);
            return this.ctx().getCodeModel().getCodeWriter().openBinary(null, fullIconPath);
        }
        catch (IOException e) {
            throw new GenerationException("Could not create file or folder " + fileName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private void copyThemesFolders(Module module) throws GenerationException {
        File iconsFolder = MulePathResolver.getFileResolvingPackages((Module)module, (String)"../../../icons/");
        if (iconsFolder.exists()) {
            File[] themeFolders;
            for (File themeFolder : themeFolders = iconsFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
                if (this.isReservedFolderName(themeFolder)) continue;
                for (File file : themeFolder.listFiles(this.acceptedFilesAsIconFilter)) {
                    this.copyFile("../../../icons/" + themeFolder.getName() + "/" + file.getName(), ICONS_NEW_FOLDER + themeFolder.getName(), module, "");
                }
            }
        }
    }

    private boolean isReservedFolderName(File themeFolder) {
        return reservedFolderNames.contains(themeFolder.getName());
    }

    private class AcceptedFilesAsIconFilter
    implements FileFilter {
        private AcceptedFilesAsIconFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.canRead() && file.getName().endsWith(MuleStudioIconsGenerator.PNG_EXTENSION);
        }
    }
}

