/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.License;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioGenerator;
import org.mule.devkit.generation.studio.MuleStudioManifestGenerator;
import org.mule.devkit.generation.studio.packaging.FutureFile;
import org.mule.devkit.generation.studio.packaging.JarArchiverWrapper;
import org.mule.devkit.generation.studio.packaging.Placeholder;
import org.mule.devkit.generation.studio.utils.ModuleComparator;
import org.mule.devkit.generation.utils.VersionUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MuleStudioFeatureGenerator
extends AbstractMuleStudioGenerator
implements MultiModuleGenerator {
    public static final String FEATURE_XML_FILENAME = "feature.xml";
    public static final String LABEL_VERSION_FORMAT = "(Mule %s+)";
    private static final List<Product> CONSUMES = Arrays.asList(Product.STUDIO_PLUGINS, Product.STUDIO_SITE_XML, Product.STUDIO_MANIFEST, Product.STUDIO_FEATURE_NAME);
    private static final List<Product> PRODUCES = Arrays.asList(Product.STUDIO_FEATURE);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    private Collection<Module> createListOfNamespaces(List<Module> modules) {
        HashMap<String, Module> namespaces = new HashMap<String, Module>();
        ArrayList<Module> sortedModules = new ArrayList<Module>(modules);
        Collections.sort(sortedModules, new ModuleComparator());
        for (Module module : sortedModules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC || namespaces.containsKey(module.getModuleName())) continue;
            namespaces.put(module.getModuleName(), module);
        }
        return namespaces.values();
    }

    public void generate(List<Module> modules) throws GenerationException {
        Collection<Module> modulesPerNamespaces = this.createListOfNamespaces(modules);
        String featureId = this.getFeatureId(modulesPerNamespaces);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element feature = document.createElement("feature");
            feature.setAttribute("id", featureId);
            feature.setAttribute("label", this.getLabel(modules, this.ctx().getMavenInformation().getName()));
            feature.setAttribute("version", VersionUtils.buildVersion((String)this.ctx().getMavenInformation().getVersion()));
            feature.setAttribute("provider-name", "Mulesoft, Inc.");
            document.appendChild(feature);
            Element licenseElement = document.createElement("license");
            this.populateLicense(licenseElement);
            feature.appendChild(licenseElement);
            for (Module module : modulesPerNamespaces) {
                MuleStudioManifestGenerator.EclipsePlugin product = (MuleStudioManifestGenerator.EclipsePlugin)this.ctx().getProduct(Product.STUDIO_MANIFEST, (Identifiable)module);
                if (product == null) continue;
                Element plugin = document.createElement("plugin");
                plugin.setAttribute("id", product.getSymbolicName());
                plugin.setAttribute("download-size", "0");
                plugin.setAttribute("install-size", "0");
                plugin.setAttribute("version", VersionUtils.buildVersion((String)this.ctx().getMavenInformation().getVersion()));
                plugin.setAttribute("unpack", "true");
                feature.appendChild(plugin);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.ctx().getCodeModel().getCodeWriter().openBinary(null, FEATURE_XML_FILENAME));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio feature.xml", (Throwable)e);
        }
        JarArchiverWrapper archiver = new JarArchiverWrapper();
        archiver.addFile(new FutureFile(Placeholder.CLASSES_DIRECTORY, FEATURE_XML_FILENAME), FEATURE_XML_FILENAME);
        for (Module module : modulesPerNamespaces) {
            archiver.addFile((JarArchiverWrapper)this.ctx().getProduct(Product.STUDIO_PLUGINS, (Identifiable)module));
        }
        archiver.setDestFile(new FutureFile(Placeholder.FEATURES_DIRECTORY, featureId + "_" + VersionUtils.buildVersion((String)this.ctx().getMavenInformation().getVersion()) + ".jar"));
        this.ctx().registerProduct(Product.STUDIO_FEATURE, (Object)archiver);
    }

    private void populateLicense(Element licenseElement) {
        License license = this.ctx().getMavenInformation().getLicense();
        if (license != null) {
            String licenseUrl = license.getUrl();
            if (licenseUrl != null) {
                licenseElement.setAttribute("url", licenseUrl);
            }
            licenseElement.setTextContent(license.getLicenseBody());
            licenseElement.setNodeValue(license.getLicenseBody());
        }
    }
}

