/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.Category;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.generation.studio.editor.MethodComparator;
import org.mule.devkit.generation.studio.editor.PatternTypes;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.Keyword;
import org.mule.devkit.model.studio.Keywords;
import org.mule.devkit.model.studio.PatternType;
import org.mule.util.StringUtils;

public class PatternTypeOperationsBuilder
extends BaseStudioXmlBuilder {
    private static final String ALIAS_ID_PREFIX = "org.mule.tooling.ui.modules.core.pattern.";
    private static final MethodComparator METHOD_COMPARATOR = new MethodComparator();
    private PatternTypes patternTypeToUse;

    public PatternTypeOperationsBuilder(Context context, Module module, PatternTypes patternTypeToUse) {
        super(context, module);
        if (!patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR) && !patternTypeToUse.equals((Object)PatternTypes.TRANSFORMER)) {
            throw new IllegalArgumentException("PatternType not supported: " + (Object)((Object)patternTypeToUse));
        }
        this.patternTypeToUse = patternTypeToUse;
    }

    public JAXBElement<PatternType> build() {
        JAXBElement namespaceTypeCloudConnector;
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        attributeCategory.getGroup().add(this.getGroup());
        PatternType patternType = new PatternType();
        patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategory);
        patternType.setCaption(this.helper.getFormattedCaption(this.module));
        if (this.patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR)) {
            patternType.setLocalId(this.module.getModuleName() + "-connector");
            patternType.setExtends("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.helper.getGlobalRefId(this.module.getModuleName()));
        } else {
            patternType.setLocalId(this.module.getModuleName() + "-transformer");
        }
        patternType.setDescription(this.helper.getFormattedDescription(this.module));
        patternType.setAliasId(ALIAS_ID_PREFIX + this.module.getModuleName());
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        patternType.setVersions(this.buildVersionsString());
        if (this.patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR)) {
            Category category = (Category)this.module.getAnnotation(Category.class);
            if (category != null && StringUtils.isNotBlank((String)category.name())) {
                patternType.setCategory(category.name());
            }
            namespaceTypeCloudConnector = this.objectFactory.createNamespaceTypeCloudConnector(patternType);
        } else {
            namespaceTypeCloudConnector = this.objectFactory.createNamespaceTypeTransformer(patternType);
        }
        if (this.module.getKeywords().isPresent()) {
            ArrayList<Keyword> keywords = new ArrayList<Keyword>();
            String values = (String)this.module.getKeywords().get();
            for (String value : values.split(",")) {
                String trimmedValue = value.trim();
                keywords.add(new Keyword(trimmedValue, Integer.valueOf(1)));
            }
            ((PatternType)namespaceTypeCloudConnector.getValue()).setKeywords(new Keywords(keywords));
        }
        return namespaceTypeCloudConnector;
    }

    private String getImage() {
        if (this.patternTypeToUse.equals((Object)PatternTypes.TRANSFORMER)) {
            return this.helper.getTransformerImage(this.module);
        }
        return this.helper.getConnectorImage(this.module);
    }

    private String getIcon() {
        if (this.patternTypeToUse.equals((Object)PatternTypes.TRANSFORMER)) {
            return this.helper.getTransformerIcon(this.module);
        }
        return this.helper.getConnectorIcon(this.module);
    }

    private Group getGroup() {
        if (this.patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR)) {
            List methods = this.module.getProcessorMethods();
            Collections.sort(methods, METHOD_COMPARATOR);
            return this.createGroupWithNoOperationModeSwitchForProcessors(methods);
        }
        List methods = this.module.getTransformerMethods();
        Collections.sort(methods, METHOD_COMPARATOR);
        return this.createGroupWithModeSwitch(methods);
    }
}

