/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import javax.xml.bind.JAXBElement;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.ParameterAdapter;
import org.mule.devkit.generation.studio.editor.PatternTypeBuilder;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.util.StringUtils;

public class OAuthPatternTypeBuilder
extends PatternTypeBuilder {
    private String methodName = null;

    public OAuthPatternTypeBuilder(Context context, String methodName, Module module) {
        super(context, null, module);
        this.methodName = methodName;
    }

    @Override
    public PatternType build() {
        return this.fillPatternType();
    }

    private PatternType fillPatternType() {
        PatternType patternType = new PatternType();
        if ("authorize".equalsIgnoreCase(this.methodName)) {
            this.buildAuthorizePatternType(patternType);
        } else if ("unauthorize".equalsIgnoreCase(this.methodName)) {
            this.buildUnauthorizePatternType(patternType);
        }
        return patternType;
    }

    private void buildAuthorizePatternType(PatternType patternType) {
        patternType.setLocalId(this.methodName);
        patternType.setCaption(this.helper.formatCaption(this.methodName));
        patternType.setAbstract(Boolean.valueOf(true));
        patternType.setExtends("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.helper.getGlobalRefId(this.module.getModuleName()));
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability((Module)this.module);
        boolean hasAdditionalParameters = oAuthCapability.getAuthorizationParameters() != null && oAuthCapability.getAuthorizationParameters().size() > 0;
        AttributeCategory attributeCategoryGeneral = new AttributeCategory();
        attributeCategoryGeneral.setCaption(this.helper.formatCaption("General"));
        attributeCategoryGeneral.setDescription(this.helper.formatDescription("General"));
        Group generalGroup = new Group();
        generalGroup.setCaption(this.helper.formatCaption("General"));
        generalGroup.setId(StringUtils.uncapitalize((String)"General"));
        attributeCategoryGeneral.getGroup().add(generalGroup);
        Group authParametersGroup = null;
        if (hasAdditionalParameters) {
            authParametersGroup = new Group();
            authParametersGroup.setCaption(this.helper.formatCaption("Additional authorization parameters"));
            authParametersGroup.setId("additionalAuthorizationParameters");
            attributeCategoryGeneral.getGroup().add(authParametersGroup);
        }
        StringAttributeType attributeType = new StringAttributeType();
        attributeType.setName("state");
        attributeType.setRequired(Boolean.valueOf(false));
        attributeType.setDescription(this.helper.formatDescription("Any value that you wish to be sent with the callback"));
        attributeType.setCaption(this.helper.formatCaption("State"));
        generalGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)attributeType));
        attributeType = new StringAttributeType();
        attributeType.setName("accessTokenUrl");
        attributeType.setRequired(Boolean.valueOf(false));
        attributeType.setDescription(this.helper.formatDescription("The URL defined by the Service Provider to obtain an access token"));
        attributeType.setCaption(this.helper.formatCaption("Access Token URL"));
        generalGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)attributeType));
        attributeType = new StringAttributeType();
        attributeType.setName("authorizationUrl");
        attributeType.setRequired(Boolean.valueOf(false));
        attributeType.setDescription(this.helper.formatDescription("The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector"));
        attributeType.setCaption(this.helper.formatCaption("Authorization URL"));
        generalGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)attributeType));
        if (oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V2) && this.module.getMinMuleVersion().atLeast("3.5")) {
            StringAttributeType accessTokenId = new StringAttributeType();
            accessTokenId.setName("accessTokenId");
            accessTokenId.setRequired(Boolean.valueOf(false));
            accessTokenId.setCaption(this.helper.formatCaption("Access Token Id"));
            accessTokenId.setDescription(this.helper.formatDescription("The id of the access token that will be used to authenticate the call"));
            accessTokenId.setJavaType("java.lang.String");
            generalGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)accessTokenId));
        }
        if (hasAdditionalParameters) {
            for (OAuthAuthorizationParameter parameter : oAuthCapability.getAuthorizationParameters()) {
                JAXBElement<? extends AttributeType> jaxbElement = this.createJaxbElement((Variable<?>)new ParameterAdapter(parameter));
                authParametersGroup.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
            }
        }
        patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategoryGeneral);
    }

    private void buildUnauthorizePatternType(PatternType patternType) {
        patternType.setLocalId(this.methodName);
        patternType.setCaption(this.helper.formatCaption(this.methodName));
        patternType.setAbstract(Boolean.valueOf(true));
        patternType.setExtends("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.helper.getGlobalRefId(this.module.getModuleName()));
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        AttributeCategory attributeCategoryGeneral = new AttributeCategory();
        attributeCategoryGeneral.setCaption(this.helper.formatCaption("General"));
        attributeCategoryGeneral.setDescription(this.helper.formatDescription("General"));
        Group generalGroup = new Group();
        generalGroup.setCaption(this.helper.formatCaption("General"));
        generalGroup.setId(StringUtils.uncapitalize((String)"General"));
        attributeCategoryGeneral.getGroup().add(generalGroup);
        StringAttributeType attributeType = new StringAttributeType();
        attributeType.setName("accessTokenId");
        attributeType.setRequired(Boolean.valueOf(false));
        attributeType.setDescription(this.helper.formatDescription("The id of the access token that will be used to authenticate the call"));
        attributeType.setCaption(this.helper.formatCaption("Access Token Id"));
        generalGroup.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)attributeType));
        patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategoryGeneral);
    }

    @Override
    protected String getImage() {
        return this.helper.getConnectorImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getConnectorIcon(this.module);
    }
}

