/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.apidoc;

import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.param.MetaDataKeyParamAffectsType;
import org.mule.devkit.model.apidoc.AbstractElement;
import org.mule.devkit.model.apidoc.misc.TypeLinkCreator;

public class Variable
extends AbstractElement {
    private String javaTypeName;
    private String fullQualifiedJavaTypeName;
    private String defaultValue;
    private Boolean isOptional = false;
    private Boolean isRefOnly = false;
    private Boolean isPayload = false;
    private Boolean isComplexType = false;
    private Boolean isEnum = false;
    private Boolean isString = false;
    private String typeMirror;
    private Boolean isHttpCallback = false;
    private Boolean isArrayOrListOrMap;
    private MetaDataKeyParamAffectsType metaDataKeyParam;

    public Boolean getArrayOrListOrMap() {
        return this.isArrayOrListOrMap;
    }

    public void setArrayOrListOrMap(Boolean arrayOrListOrMap) {
        this.isArrayOrListOrMap = arrayOrListOrMap;
    }

    public Boolean getEnum() {
        return this.isEnum;
    }

    public void setEnum(Boolean anEnum) {
        this.isEnum = anEnum;
    }

    public Boolean getString() {
        return this.isString;
    }

    public void setString(Boolean string) {
        this.isString = string;
    }

    public String getTypeMirror() {
        return this.typeMirror;
    }

    public void setTypeMirror(String typeMirror) {
        this.typeMirror = typeMirror;
    }

    public Boolean getHttpCallback() {
        return this.isHttpCallback;
    }

    public void setHttpCallback(Boolean httpCallback) {
        this.isHttpCallback = httpCallback;
    }

    public Boolean IsComplexType() {
        return this.isComplexType;
    }

    public void isComplexType(Boolean isComplexType) {
        this.isComplexType = isComplexType;
    }

    public String defaultValue() {
        return this.setEmptyForNull(this.defaultValue);
    }

    public Boolean isOptional() {
        return this.isOptional != false || StringUtils.isNotBlank((String)this.defaultValue());
    }

    public Boolean isRefOnly() {
        return this.isRefOnly;
    }

    public String javaTypeName() {
        return this.javaTypeName;
    }

    public String javaTypeFullQualifiedName() {
        return this.fullQualifiedJavaTypeName;
    }

    public void defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void isOptional(Boolean isOptional) {
        this.isOptional = isOptional;
    }

    public void isRefOnly(Boolean isRefOnly) {
        this.isRefOnly = isRefOnly;
    }

    public void fullQualifiedJavaTypeName(String fullQualifiedJavaTypeName) {
        this.fullQualifiedJavaTypeName = fullQualifiedJavaTypeName;
    }

    public void javaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public void metaDataKeyParam(Optional<MetaDataKeyParamAffectsType> type) {
        this.metaDataKeyParam = type.isPresent() ? (MetaDataKeyParamAffectsType)type.get() : null;
    }

    public boolean isDefaultPayload() {
        return "#[payload]".equals(this.defaultValue) || this.isPayload() != false;
    }

    public Boolean isPayload() {
        return this.isPayload;
    }

    public void isPayload(Boolean isPayload) {
        this.isPayload = isPayload;
    }

    public boolean isMetaDataKey() {
        return this.metaDataKeyParam != null;
    }

    public Optional<MetaDataKeyParamAffectsType> metaDataKeyAffects() {
        return Optional.fromNullable((Object)this.metaDataKeyParam);
    }

    public boolean isMetaDataType() {
        return this.javaTypeName.equals("Map<String,Object>") || this.javaTypeName.equals("List<Map<String,Object>");
    }

    public boolean isInjectable() {
        return this.javaTypeName.endsWith("MuleEvent") || this.javaTypeName.endsWith("MuleMessage");
    }

    public String javaTypeLink() {
        return TypeLinkCreator.getInstance().create(this.fullQualifiedJavaTypeName);
    }

    @Override
    public String xsdName() {
        return this.javaName();
    }
}

