/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.api.annotations.display;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Allows to specify a better label to the element and/or field to be used in Studio editor.
 * If a value is not specified, the name is inferred from the annotated element's name.
 *
 * Use this annotation to instance variables and method parameters to provide a way to override the default inferred nickname
 * for a {@link org.mule.api.annotations.Configurable} variable or a {@link org.mule.api.annotations.Processor}, {@link org.mule.api.annotations.Source} method parameter.
 *
 */
@Target({ElementType.PARAMETER, ElementType.FIELD})
@Documented
@Retention(RetentionPolicy.SOURCE)
public @interface FriendlyName {

    /**
     * The value is a short name for the annotated element. If this value is not specified it will
     * inferred from the annotated element name.
     */
    String value() default "";
}