/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.components;

import org.mule.api.annotations.AnnotationsConstants;

import java.lang.annotation.*;

/**
 * This annotation is used to define a WSDL type of strategy, that will need to be complemented with {@link org.mule.api.annotations.ws.WsdlServiceRetriever}
 * and {@link org.mule.api.annotations.ws.WsdlServiceEndpoint}.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface WsdlProvider {
    /**
     * Name of the configuration element
     */
    String configElementName() default AnnotationsConstants.CONFIG_ELEMENT_NAME;

    /**
     * Provides a friendly name for the strategy.
     */
    String friendlyName();
}
