/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.oauth;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Engage the refresh token flow and the retry mechanism automatically when the annotated method throws the
 * specified exception.
 * @deprecated Use {@link org.mule.api.annotations.ReconnectOn} instead
 * @see OAuth2
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
@Documented
@Deprecated
public @interface OAuthInvalidateAccessTokenOn {
    /**
     * The class of the exception that signals the activation of the refresh token flow
     */
    Class exception();
}
