/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * This annotation is used for exception handling related to connections. It can be used at a class level (annotated with the  {@link Connector}  annotation)
 * or at a method level (annotated with  {@link Processor}/{@link Source}) . If the Connector or  Processor  throws an exception of this class,  {@link ReconnectOn}
 * automatically invalidates the connection.  {@link ReconnectOn}   receives a list containing the classes of the exceptions to be caught
 * (see below for an example). When an exception occurs, {@link ReconnectOn}'s behavior is based on the configured reconnection strategy.
 *
 * Used to invalidate connections. You can attach this annotation to any method annotated with {@link Processor}/{@link Source}.
 * If the {@link Processor} or {@link Source} throws an exception that matches any of the exceptions specified in the {@link ReconnectOn} annotation,
 * the connection is invalidated
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface ReconnectOn {
    Class<? extends Exception>[] exceptions();
}
