/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.model.module.oauth;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenIdentifier;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.oauth.OAuthCallbackParameter;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.api.annotations.oauth.OAuthPostAuthorization;
import org.mule.api.annotations.oauth.OAuthScope;
import org.mule.devkit.apt.model.AnnotationProcessorMethod;
import org.mule.devkit.apt.model.AnnotationProcessorTypeFactory;
import org.mule.devkit.apt.model.module.oauth.AnnotationProcessorOAuthCallbackParameterField;
import org.mule.devkit.apt.model.module.oauth.OAnnotationProcessorOAuthAuthorizationParameter;
import org.mule.devkit.apt.model.module.rest.AnnotationProcessorRestModule;
import org.mule.devkit.apt.model.utils.AnnotationUtils;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.components.Component;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.security.oauth.OnNoTokenPolicy;

public class AnnotationProcessorOAuthModule
extends AnnotationProcessorRestModule
implements OAuthModule {
    public AnnotationProcessorOAuthModule(TypeElement innerElement, Types types, Elements elements, List<Component> components) {
        super(innerElement, types, elements, components);
    }

    public OAuthVersion getOAuthVersion() {
        if (this.hasAnnotation(OAuth.class)) {
            return OAuthVersion.V10A;
        }
        if (this.hasAnnotation(OAuth2.class)) {
            return OAuthVersion.V2;
        }
        return OAuthVersion.UNKNOWN;
    }

    @Override
    public boolean needsConfig() {
        return true;
    }

    public Field getConsumerKeyField() {
        for (Field<Type> field : this.getFields()) {
            if (!field.hasAnnotation(OAuthConsumerKey.class)) continue;
            return field;
        }
        return null;
    }

    public Field getConsumerSecretField() {
        for (Field<Type> field : this.getFields()) {
            if (!field.hasAnnotation(OAuthConsumerSecret.class)) continue;
            return field;
        }
        return null;
    }

    public Field getAccessTokenField() {
        for (Field<Type> field : this.getFields()) {
            if (!field.hasAnnotation(OAuthAccessToken.class)) continue;
            return field;
        }
        return null;
    }

    public Field getScopeField() {
        for (Field<Type> field : this.getFields()) {
            if (!field.hasAnnotation(OAuthScope.class)) continue;
            return field;
        }
        return null;
    }

    public Field getAccessTokenSecretField() {
        for (Field<Type> field : this.getFields()) {
            if (!field.hasAnnotation(OAuthAccessTokenSecret.class)) continue;
            return field;
        }
        return null;
    }

    public String getVerifierRegex() {
        if (this.hasAnnotation(OAuth.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).verifierRegex();
        }
        if (this.hasAnnotation(OAuth2.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).verifierRegex();
        }
        return null;
    }

    public String getRequestTokenUrl() {
        if (this.hasAnnotation(OAuth.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).requestTokenUrl();
        }
        return null;
    }

    public String getAccessTokenUrl() {
        if (this.hasAnnotation(OAuth.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).accessTokenUrl();
        }
        if (this.hasAnnotation(OAuth2.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).accessTokenUrl();
        }
        return null;
    }

    public String getAuthorizationUrl() {
        if (this.hasAnnotation(OAuth.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth.class).authorizationUrl();
        }
        if (this.hasAnnotation(OAuth2.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).authorizationUrl();
        }
        return null;
    }

    public String getExpirationRegex() {
        if (this.hasAnnotation(OAuth2.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).expirationRegex();
        }
        return null;
    }

    public String getAccessTokenRegex() {
        if (this.hasAnnotation(OAuth2.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).accessTokenRegex();
        }
        return null;
    }

    public String getRefreshTokenRegex() {
        if (this.hasAnnotation(OAuth2.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).refreshTokenRegex();
        }
        return null;
    }

    public List<OAuthAuthorizationParameter> getAuthorizationParameters() {
        if (this.hasAnnotation(OAuth2.class) && ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).authorizationParameters().length == 0) {
            return new ArrayList<OAuthAuthorizationParameter>();
        }
        if (this.hasAnnotation(OAuth.class) && ((TypeElement)this.innerElement).getAnnotation(OAuth.class).authorizationParameters().length == 0) {
            return new ArrayList<OAuthAuthorizationParameter>();
        }
        ArrayList<OAuthAuthorizationParameter> authorizationParameters = new ArrayList<OAuthAuthorizationParameter>();
        List<AnnotationMirror> annotationMirrors = this.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (OAuth2.class.getName().equals(annotationMirror.getAnnotationType().toString())) {
                this.getAuthorizationParametersFromAnnotationMirror(authorizationParameters, annotationMirror);
                continue;
            }
            if (!OAuth.class.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            this.getAuthorizationParametersFromAnnotationMirror(authorizationParameters, annotationMirror);
        }
        return authorizationParameters;
    }

    private void getAuthorizationParametersFromAnnotationMirror(List<OAuthAuthorizationParameter> authorizationParameters, AnnotationMirror annotationMirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!"authorizationParameters".equals(entry.getKey().getSimpleName().toString())) continue;
            for (AnnotationValue value : (List)entry.getValue().getValue()) {
                AnnotationMirror secondMirror = AnnotationUtils.getAnnotationMirror(value);
                DeclaredType type = null;
                String name = "";
                boolean isOptional = false;
                String defaultValue = "";
                String description = "";
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> secondEntry : secondMirror.getElementValues().entrySet()) {
                    if ("type".equals(secondEntry.getKey().getSimpleName().toString())) {
                        type = (DeclaredType)secondEntry.getValue().getValue();
                    }
                    if ("name".equals(secondEntry.getKey().getSimpleName().toString())) {
                        name = (String)secondEntry.getValue().getValue();
                    }
                    if ("optional".equals(secondEntry.getKey().getSimpleName().toString())) {
                        isOptional = (Boolean)secondEntry.getValue().getValue();
                    }
                    if ("defaultValue".equals(secondEntry.getKey().getSimpleName().toString())) {
                        defaultValue = (String)secondEntry.getValue().getValue();
                    }
                    if (!"description".equals(secondEntry.getKey().getSimpleName().toString())) continue;
                    description = (String)secondEntry.getValue().getValue();
                }
                Object realType = AnnotationProcessorTypeFactory.createType((TypeElement)type.asElement(), this.types, this.elements, this.components);
                authorizationParameters.add(new OAnnotationProcessorOAuthAuthorizationParameter(name, description, isOptional, defaultValue, (Type)realType));
            }
        }
    }

    public List<OAuthCallbackParameterField> getCallbackParameters() {
        ArrayList<OAuthCallbackParameterField> fields = new ArrayList<OAuthCallbackParameterField>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (variableElement.getAnnotation(OAuthCallbackParameter.class) == null) continue;
            fields.add(new AnnotationProcessorOAuthCallbackParameterField(variableElement, this, this.types, this.elements));
        }
        return fields;
    }

    public Method<OAuthModule> getPostAuthorizationMethod() {
        for (ExecutableElement executableElement : ElementFilter.methodsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (executableElement.getAnnotation(OAuthPostAuthorization.class) == null) continue;
            return new AnnotationProcessorMethod<OAuthModule>(executableElement, this, this.types, this.elements);
        }
        return null;
    }

    public Method<OAuthModule> getUserIdentifierMethod() {
        for (ExecutableElement executableElement : ElementFilter.methodsIn(((TypeElement)this.innerElement).getEnclosedElements())) {
            if (executableElement.getAnnotation(OAuthAccessTokenIdentifier.class) == null) continue;
            return new AnnotationProcessorMethod<OAuthModule>(executableElement, this, this.types, this.elements);
        }
        return null;
    }

    @Override
    public void accept(ModelVisitor visitor) {
        if (!visitor.hasVisited((Identifiable)this)) {
            super.accept(visitor);
            List<OAuthAuthorizationParameter> authorizationParameters = this.getAuthorizationParameters();
            if (authorizationParameters != null) {
                for (OAuthAuthorizationParameter authorizationParameter : authorizationParameters) {
                    authorizationParameter.getType().accept(visitor);
                }
            }
        }
    }

    public DeclaredType getOAuthProvider() {
        if (this.hasAnnotation(OAuth.class)) {
            String oauth = OAuth.class.getName();
            DeclaredType provider = null;
            List<AnnotationMirror> annotationMirrors = this.getAnnotationMirrors();
            block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!oauth.equals(annotationMirror.getAnnotationType().toString())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!"provider".equals(entry.getKey().getSimpleName().toString())) continue;
                    provider = (DeclaredType)entry.getValue().getValue();
                    continue block0;
                }
            }
            return provider;
        }
        return null;
    }

    public OnNoTokenPolicy getTokenPolicy() {
        if (this.hasAnnotation(OAuth2.class)) {
            return ((TypeElement)this.innerElement).getAnnotation(OAuth2.class).onNoTokenPolicy();
        }
        return null;
    }
}

