/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt.dependency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.mule.devkit.generation.api.Dependency;
import org.mule.devkit.generation.api.Scope;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;

public class SimpleDependency
implements Dependency {
    private String artifactId;
    private String groupId;
    private String version;
    private Scope scope;
    private boolean optional;

    SimpleDependency(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, Scope.COMPILE);
    }

    SimpleDependency(String groupId, String artifactId, String version, Scope scope) {
        this(groupId, artifactId, version, scope, false);
    }

    SimpleDependency(String groupId, String artifactId, String version, Scope scope, boolean optional) {
        Validate.notNull((Object)groupId);
        Validate.notNull((Object)artifactId);
        Validate.notNull((Object)version);
        Validate.notNull((Object)scope);
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.version = version;
        this.scope = scope;
        this.optional = optional;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public static Set<Dependency> createDependencies(Collection<String> stringDependencies) {
        HashSet<Dependency> dependencySet = new HashSet<Dependency>();
        for (String stringDependency : stringDependencies) {
            Dependency dependency = SimpleDependency.create(stringDependency);
            dependencySet.add(dependency);
        }
        return Collections.unmodifiableSet(dependencySet);
    }

    public static Set<Dependency> createDependencies(String[] stringDependencies) {
        HashSet<Dependency> dependencySet = new HashSet<Dependency>();
        for (String stringDependency : stringDependencies) {
            Dependency dependency = SimpleDependency.create(stringDependency);
            dependencySet.add(dependency);
        }
        return Collections.unmodifiableSet(dependencySet);
    }

    public static Dependency create(String dependencyString) {
        String[] dependencyStringParts = dependencyString.split(":");
        if (dependencyStringParts.length < 3 || dependencyStringParts.length > 5) {
            throw new IllegalArgumentException("Invalid dependency as string: [" + dependencyString + "]");
        }
        if (dependencyStringParts.length == 3) {
            return new SimpleDependency(dependencyStringParts[0], dependencyStringParts[1], dependencyStringParts[2]);
        }
        if (dependencyStringParts.length == 5) {
            return new SimpleDependency(dependencyStringParts[0], dependencyStringParts[1], dependencyStringParts[2], Scope.valueOf((String)dependencyStringParts[3].toUpperCase()), Boolean.parseBoolean(dependencyStringParts[4]));
        }
        return new SimpleDependency(dependencyStringParts[0], dependencyStringParts[1], dependencyStringParts[2], Scope.valueOf((String)dependencyStringParts[3].toUpperCase()));
    }

    private static Dependency create(org.mule.devkit.generation.api.annotations.Dependency dependencyAnnotation) {
        return new SimpleDependency(dependencyAnnotation.groupId(), dependencyAnnotation.artifactId(), dependencyAnnotation.version(), dependencyAnnotation.scope());
    }

    public static Set<Dependency> createDependencies(RequiresMavenDependencies verifierAnnotation, RequiresMavenDependencies pluginAnnotation) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        if (verifierAnnotation != null) {
            dependencies.addAll(SimpleDependency.createDependencies(verifierAnnotation.value()));
        }
        if (pluginAnnotation != null) {
            dependencies.addAll(SimpleDependency.createDependencies(pluginAnnotation.value()));
        }
        return dependencies;
    }

    private static Collection<? extends Dependency> createDependencies(org.mule.devkit.generation.api.annotations.Dependency[] dependencies) {
        HashSet<Dependency> dependencySet = new HashSet<Dependency>();
        for (org.mule.devkit.generation.api.annotations.Dependency dependencyAnnotation : dependencies) {
            Dependency dependency = SimpleDependency.create(dependencyAnnotation);
            dependencySet.add(dependency);
        }
        return Collections.unmodifiableSet(dependencySet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDependency that = (SimpleDependency)o;
        if (this.optional != that.optional) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.artifactId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.scope.hashCode();
        result = 31 * result + (this.optional ? 1 : 0);
        return result;
    }
}

