/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.testdata.model;

import com.mule.connectors.testdata.model.JarDependency;
import com.mule.connectors.testdata.model.adapter.MetadataEnumAdapter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConnectorProperties {
    @XmlTransient
    private String name = "";
    @XmlElement(name="connectivity-support")
    private Boolean connectivitySupport = false;
    @XmlElement(name="OAuth-authentication")
    private Boolean oauthSupport = false;
    @XmlElement(name="metadata")
    @XmlJavaTypeAdapter(value=MetadataEnumAdapter.class)
    private MetadataType metadataType = MetadataType.STATIC;
    @XmlElement(name="datasense-enabled")
    private Boolean datasenseEnabled = true;
    @XmlElement(name="transformer")
    private Boolean isTransformer = false;
    @XmlElementWrapper(name="dependencies")
    @XmlElement(name="dependency")
    private List<JarDependency> dependencies;

    public void setConnectivitySupport(Boolean connectivitySupport) {
        this.connectivitySupport = connectivitySupport;
    }

    public void setOauthSupport(Boolean oauthSupport) {
        this.oauthSupport = oauthSupport;
    }

    public void setMetadataType(MetadataType type) {
        this.metadataType = type;
    }

    public void setDatasenseEnabled(Boolean datasenseEnabled) {
        this.datasenseEnabled = datasenseEnabled;
    }

    public void setIsTransformer(Boolean isTransformer) {
        this.isTransformer = isTransformer;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    public boolean hasTransformerDefinition() {
        return this.isTransformer;
    }

    public boolean hasOAuthAuthentication() {
        return this.oauthSupport;
    }

    public boolean hasConnectivitySupport() {
        return this.connectivitySupport;
    }

    public boolean hasDatasenseEnabled() {
        return this.datasenseEnabled;
    }

    public boolean hasDynamicMetadata() {
        return this.metadataType == MetadataType.DYNAMIC;
    }

    public void addDependency(JarDependency jar) {
        if (this.dependencies == null) {
            this.dependencies = new LinkedList<JarDependency>();
        }
        if (jar != null && !this.dependencies.contains(jar)) {
            this.dependencies.add(jar);
        }
    }

    public List<JarDependency> getDependencies() {
        return this.dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorProperties)) {
            return false;
        }
        ConnectorProperties that = (ConnectorProperties)o;
        return this.connectivitySupport.equals(that.hasConnectivitySupport()) && this.datasenseEnabled.equals(that.hasDatasenseEnabled()) && this.isTransformer.equals(that.hasTransformerDefinition()) && this.metadataType.equals((Object)that.getMetadataType()) && this.oauthSupport.equals(that.hasOAuthAuthentication()) && StringUtils.equals((String)this.name, (String)that.getName());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.connectivitySupport.hashCode();
        result = 31 * result + this.oauthSupport.hashCode();
        result = 31 * result + this.metadataType.hashCode();
        result = 31 * result + this.datasenseEnabled.hashCode();
        result = 31 * result + this.isTransformer.hashCode();
        return result;
    }

    public static enum MetadataType {
        DYNAMIC,
        STATIC,
        NONE;

    }
}

