/*
 * Decompiled with CFR 0.152.
 */
package com.javaforge.bobber.archetype.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Variable
implements Serializable {
    private String name;
    private String description;
    private String defvalue;
    private List variables;
    private String modelEncoding = "UTF-8";

    public void addVariable(Variable variable) {
        if (!(variable instanceof Variable)) {
            throw new ClassCastException("Variable.addVariables(variable) parameter must be instanceof " + Variable.class.getName());
        }
        this.getVariables().add(variable);
        variable.createVariableAssociation(this);
    }

    public void breakVariableAssociation(Variable variable) {
        if (!this.getVariables().contains(variable)) {
            throw new IllegalStateException("variable isn't associated.");
        }
        this.getVariables().remove(variable);
    }

    public void createVariableAssociation(Variable variable) {
        List variables = this.getVariables();
        if (this.getVariables().contains(variable)) {
            throw new IllegalStateException("variable is already assigned.");
        }
        variables.add(variable);
    }

    public String getDefvalue() {
        return this.defvalue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public List getVariables() {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        return this.variables;
    }

    public void removeVariable(Variable variable) {
        if (!(variable instanceof Variable)) {
            throw new ClassCastException("Variable.removeVariables(variable) parameter must be instanceof " + Variable.class.getName());
        }
        variable.breakVariableAssociation(this);
        this.getVariables().remove(variable);
    }

    public void setDefvalue(String defvalue) {
        this.defvalue = defvalue;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVariables(List variables) {
        this.variables = variables;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

