/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.flow;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.activation.DataHandler;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.util.message.ItemSequenceInfoUtils;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class TestEventBuilder {
    private Object payload;
    private Object attributes;
    private MediaType mediaType = MediaType.ANY;
    private Map<String, Serializable> inboundProperties = new HashMap<String, Serializable>();
    private Map<String, Serializable> outboundProperties = new HashMap<String, Serializable>();
    private Map<String, DataHandler> inboundAttachments = new HashMap<String, DataHandler>();
    private Map<String, Attachment> outboundAttachments = new HashMap<String, Attachment>();
    private Map<String, Object> sessionProperties = new HashMap<String, Object>();
    private String sourceCorrelationId = null;
    private ItemSequenceInfo itemSequenceInfo;
    private SecurityContext securityContext;
    private Map<String, TypedValue> variables = new HashMap<String, TypedValue>();
    private Function<Message, Message> spyMessage = input -> input;
    private Function<CoreEvent, CoreEvent> spyEvent = input -> input;
    private CompletableFuture<Void> externalCompletionCallback;

    public TestEventBuilder withPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public TestEventBuilder withMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public TestEventBuilder withAttributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @Deprecated
    public TestEventBuilder withInboundProperty(String key, Serializable value) {
        this.inboundProperties.put(key, value);
        return this;
    }

    @Deprecated
    public TestEventBuilder withInboundProperties(Map<String, Serializable> properties) {
        this.inboundProperties.putAll(properties);
        return this;
    }

    @Deprecated
    public TestEventBuilder withOutboundProperty(String key, Serializable value) {
        this.outboundProperties.put(key, value);
        return this;
    }

    @Deprecated
    public TestEventBuilder withInboundAttachment(String key, DataHandler value) {
        this.inboundAttachments.put(key, value);
        return this;
    }

    @Deprecated
    public TestEventBuilder withSessionProperty(String key, Object value) {
        this.sessionProperties.put(key, value);
        return this;
    }

    public TestEventBuilder withSourceCorrelationId(String sourceCorrelationId) {
        this.sourceCorrelationId = sourceCorrelationId;
        return this;
    }

    public TestEventBuilder withCorrelation(GroupCorrelation groupCorrelation) {
        return this.withItemSequenceInfo(ItemSequenceInfoUtils.fromGroupCorrelation((GroupCorrelation)groupCorrelation));
    }

    public TestEventBuilder withItemSequenceInfo(ItemSequenceInfo itemSequenceInfo) {
        this.itemSequenceInfo = itemSequenceInfo;
        return this;
    }

    public TestEventBuilder withSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    public TestEventBuilder withVariable(String key, Object value) {
        this.variables.put(key, new TypedValue(value, null));
        return this;
    }

    public TestEventBuilder withVariable(String key, Object value, DataType dataType) {
        this.variables.put(key, new TypedValue(value, dataType));
        return this;
    }

    public TestEventBuilder spyObjects() {
        this.spyMessage = input -> (Message)Mockito.spy((Object)input);
        this.spyEvent = input -> (CoreEvent)Mockito.spy((Object)input);
        return this;
    }

    public TestEventBuilder setExternalCompletionCallback(CompletableFuture<Void> externalCompletionCallback) {
        this.externalCompletionCallback = externalCompletionCallback;
        return this;
    }

    public CoreEvent build(FlowConstruct flow) {
        Message.Builder messageBuilder = Message.builder().value(this.payload).mediaType(this.mediaType);
        this.setInboundProperties(messageBuilder, this.inboundProperties);
        this.setOutboundProperties(messageBuilder, this.outboundProperties);
        if (this.attributes != null) {
            messageBuilder.attributesValue(this.attributes);
        }
        Message muleMessage = messageBuilder.build();
        EventContext eventContext = this.getEventContext(flow);
        CoreEvent.Builder builder = InternalEvent.builder((EventContext)eventContext).message(this.spyMessage.apply(muleMessage)).itemSequenceInfo(Optional.ofNullable(this.itemSequenceInfo)).securityContext(this.securityContext);
        for (Map.Entry<String, TypedValue> variableEntry : this.variables.entrySet()) {
            builder.addVariable(variableEntry.getKey(), variableEntry.getValue().getValue(), variableEntry.getValue().getDataType());
        }
        CoreEvent event = builder.build();
        for (Map.Entry<String, Attachment> outboundAttachmentEntry : this.outboundAttachments.entrySet()) {
            event = outboundAttachmentEntry.getValue().addOutboundTo(event, outboundAttachmentEntry.getKey());
        }
        for (Map.Entry<String, Object> sessionPropertyEntry : this.sessionProperties.entrySet()) {
            ((PrivilegedEvent)event).getSession().setProperty(sessionPropertyEntry.getKey(), sessionPropertyEntry.getValue());
        }
        return this.spyEvent.apply(event);
    }

    private EventContext getEventContext(FlowConstruct flow) {
        DefaultComponentLocation location = ((DefaultComponentLocation)DefaultComponentLocation.from((String)flow.getName())).appendProcessorsPart().appendLocationPart("0", Optional.of(TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.OPERATION).identifier(ComponentIdentifier.buildFromStringRepresentation((String)"test")).build()), Optional.empty(), OptionalInt.empty(), OptionalInt.empty());
        EventContext eventContext = this.externalCompletionCallback != null ? EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)location, (String)this.sourceCorrelationId, Optional.of(this.externalCompletionCallback)) : EventContextFactory.create((FlowConstruct)flow, (ComponentLocation)location, (String)this.sourceCorrelationId);
        return eventContext;
    }

    private void setInboundProperties(Message.Builder messageBuilder, Map<String, Serializable> inboundProperties) {
        try {
            Method inboundPropertiesMethod = messageBuilder.getClass().getMethod("inboundProperties", Map.class);
            inboundPropertiesMethod.invoke((Object)messageBuilder, inboundProperties);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void setOutboundProperties(Message.Builder messageBuilder, Map<String, Serializable> outboundProperties) {
        try {
            Method outboundPropertiesMethod = messageBuilder.getClass().getMethod("outboundProperties", Map.class);
            outboundPropertiesMethod.invoke((Object)messageBuilder, outboundProperties);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static interface Attachment {
        public CoreEvent addOutboundTo(CoreEvent var1, String var2);
    }
}

