/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import jakarta.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;

public class ThrowProcessor
extends AbstractComponent
implements Processor {
    private static final String EXCEPTION_ERROR = "If an error is not provided, the provided exception must be a TypedException.";
    private Class<? extends Throwable> exception;
    private String error;
    private volatile int count = -1;
    @Inject
    private MuleContext muleContext;

    public CoreEvent process(CoreEvent event) throws MuleException {
        if (this.count == -1 || this.count-- > 0) {
            try {
                Throwable instantiatedException = this.exception.newInstance();
                if (this.error != null) {
                    ErrorTypeRepository errorTypeRepository = this.muleContext.getErrorTypeRepository();
                    ErrorType errorType = (ErrorType)errorTypeRepository.lookupErrorType(ComponentIdentifier.buildFromStringRepresentation((String)this.error)).orElseThrow(() -> new DefaultMuleException(String.format("Could not find error: '%s'", this.error)));
                    throw new TypedException(instantiatedException, errorType);
                }
                Preconditions.checkArgument((boolean)(instantiatedException instanceof TypedException), (String)EXCEPTION_ERROR);
                throw (TypedException)instantiatedException;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DefaultMuleException(String.format("Failed to instantiate exception class '%s'", this.exception.getSimpleName()));
            }
        }
        return event;
    }

    public void setException(Class<? extends Throwable> exception) {
        this.exception = exception;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

