/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.transformer;

import java.io.InputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.transformer.ExtendedTransformationService;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.InvalidSatsuma;

public abstract class AbstractTransformerTestCase
extends AbstractMuleContextTestCase {
    protected String normalizeString(String rawString) {
        rawString = rawString.replaceAll("\r", "");
        rawString = rawString.replaceAll("\n", "");
        return rawString.replaceAll("\t", "");
    }

    @Test
    public void testTransform() throws Exception {
        Transformer trans = this.getTransformer();
        Object result = trans.transform(this.getTestData());
        Object expectedResult = this.getResultData();
        boolean match = this.compareResults(expectedResult, result);
        if (!match) {
            Assert.fail((String)String.format("Transformation result does not match expected result. Expected '%s', but got '%s'", expectedResult, result));
        }
    }

    @Test
    public void testRoundtripTransform() throws Exception {
        Transformer roundTripTransformer = this.getRoundTripTransformer();
        if (roundTripTransformer != null) {
            Object result = roundTripTransformer.transform(this.getResultData());
            Assert.assertNotNull((String)"The result of the roundtrip transform shouldn't be null", (Object)result);
            boolean match = this.compareRoundtripResults(this.getTestData(), result);
            if (!match) {
                Assert.fail((String)String.format("The result of the roundtrip transform does not match expected result. Expected '%s', but got '%s'", this.getTestData(), result));
            }
        }
    }

    @Test
    public void testBadReturnType() throws Exception {
        this.doTestBadReturnType(this.getTransformer(), this.getTestData());
    }

    @Test
    public void testRoundtripBadReturnType() throws Exception {
        if (this.getRoundTripTransformer() != null) {
            this.doTestBadReturnType(this.getRoundTripTransformer(), this.getResultData());
        }
    }

    @Test
    public void testRoundTrip() throws Exception {
        if (this.getRoundTripTransformer() != null) {
            Transformer trans = this.getTransformer();
            Transformer trans2 = this.getRoundTripTransformer();
            Message message = Message.of((Object)this.getTestData());
            message = ((ExtendedTransformationService)muleContext.getTransformationService()).applyTransformers(message, null, Arrays.asList(trans, trans2));
            Object result = message.getPayload().getValue();
            this.compareRoundtripResults(this.getTestData(), result);
        }
    }

    public void doTestBadReturnType(Transformer tran, Object src) throws Exception {
        tran.setReturnDataType(DataType.fromType(InvalidSatsuma.class));
        try {
            tran.transform(src);
            Assert.fail((String)"Should throw exception for bad return type");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    protected void doTestClone(Transformer original, Transformer clone) throws Exception {
        Assert.assertNotSame((Object)original, (Object)clone);
    }

    public abstract Transformer getTransformer() throws Exception;

    public abstract Transformer getRoundTripTransformer() throws Exception;

    public abstract Object getTestData();

    public abstract Object getResultData();

    public boolean compareResults(Object expected, Object result) {
        if (expected == null && result == null) {
            return true;
        }
        if (expected == null || result == null) {
            return false;
        }
        if (expected instanceof Object[] && result instanceof Object[]) {
            return Arrays.equals((Object[])expected, (Object[])result);
        }
        if (expected instanceof byte[] && result instanceof byte[]) {
            return Arrays.equals((byte[])expected, (byte[])result);
        }
        if (expected instanceof InputStream && result instanceof InputStream) {
            return IOUtils.toString((InputStream)((InputStream)expected)).equals(IOUtils.toString((InputStream)((InputStream)result)));
        }
        if (expected instanceof InputStream) {
            expected = IOUtils.toString((InputStream)((InputStream)expected));
        }
        if (expected instanceof String && result instanceof String) {
            expected = this.normalizeString((String)expected);
            result = this.normalizeString((String)result);
        }
        return expected.equals(result);
    }

    public boolean compareRoundtripResults(Object expected, Object result) {
        return this.compareResults(expected, result);
    }
}

