/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.util.store;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.core.api.config.i18n.CoreMessages;

public class InMemoryObjectStore<T extends Serializable>
extends TemplateObjectStore<T> {
    protected final ConcurrentSkipListMap<Long, StoredObject<T>> store = new ConcurrentSkipListMap();

    public boolean isPersistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doContains(String key) throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            return this.store.values().contains(new StoredObject<Object>(key, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStore(String id, T value) throws ObjectStoreException {
        if (id == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull((String)"id"));
        }
        StoredObject<T> obj = new StoredObject<T>(id, value);
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            if (this.store.values().contains(obj)) {
                throw new ObjectAlreadyExistsException();
            }
            boolean written = false;
            while (!written) {
                Long key = System.nanoTime();
                written = this.store.put(key, obj) == null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doRetrieve(String key) throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry((Serializable)((Object)key));
            if (entry != null) {
                StoredObject object = (StoredObject)entry.getValue();
                return (T)((Serializable)object.getItem());
            }
        }
        throw new ObjectDoesNotExistException(CoreMessages.objectNotFound((Object)key));
    }

    private Map.Entry<?, ?> findEntry(Serializable key) {
        for (Map.Entry<Long, StoredObject<T>> o : this.store.entrySet()) {
            Map.Entry<Long, StoredObject<T>> entry = o;
            StoredObject<T> object = entry.getValue();
            if (!object.getId().equals(key)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doRemove(String key) throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry((Serializable)((Object)key));
            if (entry != null) {
                StoredObject<T> removedObject = this.store.remove(entry.getKey());
                return (T)((Serializable)removedObject.getItem());
            }
        }
        throw new ObjectDoesNotExistException(CoreMessages.objectNotFound((Object)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            this.store.clear();
        }
    }

    public void open() throws ObjectStoreException {
    }

    public void close() throws ObjectStoreException {
    }

    public List<String> allKeys() throws ObjectStoreException {
        return this.store.keySet().stream().map(String::valueOf).collect(Collectors.toList());
    }

    public Map<String, T> retrieveAll() throws ObjectStoreException {
        return this.store.values().stream().collect(Collectors.toMap(StoredObject::getId, StoredObject::getItem));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.store;
    }

    protected static class StoredObject<T> {
        private final String id;
        private final T item;

        StoredObject(String id, T item) {
            this.id = id;
            this.item = item;
        }

        public String getId() {
            return this.id;
        }

        public T getItem() {
            return this.item;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredObject that = (StoredObject)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StoredObject");
            sb.append("{id='").append(this.id).append('\'');
            sb.append(", item=").append(this.item);
            sb.append('}');
            return sb.toString();
        }
    }
}

