/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.processor.Processor;

public class FlowTraceUtils {
    @SafeVarargs
    public static void assertStackElements(FlowCallStack flowStack, Matcher<FlowStackElement> ... flowStackElementMatchers) {
        Assert.assertThat((String)flowStack.toString(), (Object)flowStack.getElements(), (Matcher)IsCollectionWithSize.hasSize((int)flowStackElementMatchers.length));
        int i = 0;
        for (Matcher<FlowStackElement> flowStackElementMatcher : flowStackElementMatchers) {
            Assert.assertThat((String)flowStack.toString(), (Object)((FlowStackElement)flowStack.getElements().get(i)), flowStackElementMatcher);
            ++i;
        }
    }

    public static Matcher<FlowStackElement> isFlowStackElement(String executingLocation) {
        return FlowTraceUtils.isFlowStackElement((Matcher<String>)IsEqual.equalTo((Object)executingLocation));
    }

    public static Matcher<FlowStackElement> isFlowStackElement(final Matcher<String> executingLocationMatcher) {
        return new TypeSafeMatcher<FlowStackElement>(){

            protected boolean matchesSafely(FlowStackElement flowStackElement) {
                return executingLocationMatcher.matches((Object)flowStackElement.executingLocation().getLocation());
            }

            public void describeTo(Description description) {
                description.appendText("<");
                executingLocationMatcher.describeTo(description);
            }
        };
    }

    public static Matcher<FlowStackElement> isFlowStackElement(final String flowName, final String executingMessageProcessor) {
        return new TypeSafeMatcher<FlowStackElement>(){

            protected boolean matchesSafely(FlowStackElement flowStackElement) {
                return flowStackElement.getFlowName().startsWith(flowName) && (executingMessageProcessor == null ? flowStackElement.getProcessorPath() == null : flowStackElement.getProcessorPath().startsWith(executingMessageProcessor + " @"));
            }

            public void describeTo(Description description) {
                if (executingMessageProcessor == null) {
                    description.appendText("<").appendText(flowName);
                } else {
                    description.appendText("<").appendText(flowName).appendText("(").appendText(executingMessageProcessor).appendText("*)");
                }
            }
        };
    }

    public static Matcher<FlowStackElement> withChainIdentifier(final ComponentIdentifier chainIdentifier) {
        return new TypeSafeMatcher<FlowStackElement>(){

            protected boolean matchesSafely(FlowStackElement flowStackElement) {
                return flowStackElement.getChainIdentifier().equals(chainIdentifier);
            }

            public void describeTo(Description description) {
                description.appendText("identifier with namespace ").appendValue((Object)chainIdentifier.getNamespace()).appendText(" and name ").appendValue((Object)chainIdentifier.getName());
            }

            protected void describeMismatchSafely(FlowStackElement flowStackElement, Description mismatchDescription) {
                mismatchDescription.appendText("identifier with namespace ").appendValue((Object)flowStackElement.getChainIdentifier().getNamespace()).appendText(" and name ").appendValue((Object)flowStackElement.getChainIdentifier().getName());
            }
        };
    }

    public static class FlowStackAsyncAsserter
    extends FlowStackAsserter {
        public static CountDownLatch latch;

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            super.process(event);
            latch.countDown();
            return event;
        }
    }

    public static class FlowStackAsserter
    implements Processor,
    Disposable {
        @Inject
        private EventContextService eventContextService;
        public static FlowCallStack stackToAssert;

        public CoreEvent process(CoreEvent event) throws MuleException {
            this.eventContextService.getCurrentlyActiveFlowStacks().stream().filter(fsde -> fsde.getEventId().equals(event.getContext().getId())).findAny().ifPresent(dumpEntry -> {
                stackToAssert = dumpEntry.getFlowCallStack().clone();
            });
            return event;
        }

        public void dispose() {
            stackToAssert = null;
        }
    }
}

