/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.maven.pom.parser.api.model.MavenModelBuilder;
import org.mule.maven.pom.parser.api.model.MavenModelBuilderProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;

public abstract class AbstractDependencyFileBuilder<T extends AbstractDependencyFileBuilder<T>> {
    private static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    private final String artifactId;
    private final List<AbstractDependencyFileBuilder> dependencies = new ArrayList<AbstractDependencyFileBuilder>();
    private final List<AbstractDependencyFileBuilder> sharedLibraries = new ArrayList<AbstractDependencyFileBuilder>();
    private String groupId = "org.mule.test";
    private String version = "1.0.0";
    private final String type = "jar";
    private String classifier;
    private String scope;
    private File artifactPomFile;
    private File artifactPomPropertiesFile;
    private File tempFolder;

    public AbstractDependencyFileBuilder(String artifactId) {
        Preconditions.checkArgument((artifactId != null ? 1 : 0) != 0, (Object)"artifact id cannot be null");
        this.artifactId = artifactId;
    }

    protected String getTempFolder() {
        if (this.tempFolder == null) {
            this.tempFolder = new File(SystemUtils.JAVA_IO_TMPDIR, this.getArtifactId() + System.currentTimeMillis());
            this.tempFolder.deleteOnExit();
            if (this.tempFolder.exists()) {
                this.tempFolder.delete();
            }
            this.tempFolder.mkdir();
        }
        return this.tempFolder.getAbsolutePath();
    }

    public T tempFolder(File tempFolder) {
        Preconditions.checkArgument((tempFolder != null ? 1 : 0) != 0, (Object)"tempFolder cannot be null");
        Preconditions.checkArgument((boolean)tempFolder.isDirectory(), (Object)"tempFolder must be a directory");
        this.tempFolder = tempFolder;
        return this.getThis();
    }

    public abstract File getArtifactFile();

    public File getArtifactPomFile() {
        if (this.artifactPomFile == null) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.artifactId) ? 1 : 0) != 0, (Object)"Filename cannot be empty");
            File tempFile = new File(this.getTempFolder(), this.artifactId + ".pom");
            tempFile.deleteOnExit();
            MavenModelBuilder model = MavenModelBuilderProvider.discoverProvider().createMavenModelBuilder(this.getGroupId(), this.getArtifactId(), this.getVersion(), Optional.of("4.0.0"), Optional.empty());
            if (!this.sharedLibraries.isEmpty()) {
                this.createMuleMavenPlugin(model);
            }
            for (AbstractDependencyFileBuilder fileBuilderDependency : this.dependencies) {
                model.addDependency(fileBuilderDependency.getAsMavenDependency());
            }
            this.artifactPomFile = new File(tempFile.getAbsolutePath());
            model.updateArtifactPom(this.artifactPomFile.toPath());
        }
        return this.artifactPomFile;
    }

    public File getArtifactPomPropertiesFile() {
        if (this.artifactPomPropertiesFile == null) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)this.artifactId) ? 1 : 0) != 0, (Object)"Filename cannot be empty");
            File tempFile = new File(this.getTempFolder(), "pom.properties");
            tempFile.deleteOnExit();
            this.artifactPomPropertiesFile = new File(tempFile.getAbsolutePath());
            Properties pomProperties = new Properties();
            pomProperties.setProperty("groupId", this.getGroupId());
            pomProperties.setProperty("artifactId", this.getArtifactId());
            pomProperties.setProperty("version", this.getVersion());
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.artifactPomPropertiesFile);){
                pomProperties.store(fileOutputStream, null);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return this.artifactPomPropertiesFile;
    }

    private void createMuleMavenPlugin(MavenModelBuilder model) {
        this.dependencies.stream().filter(this.sharedLibraries::contains).forEach(sharedLibrary -> model.addSharedLibraryDependency(sharedLibrary.groupId, sharedLibrary.artifactId));
    }

    public T dependingOn(AbstractDependencyFileBuilder dependencyFileBuilder) {
        this.dependencies.add(dependencyFileBuilder);
        return this.getThis();
    }

    public T dependingOnSharedLibrary(AbstractDependencyFileBuilder dependencyFileBuilder) {
        this.dependencies.add(dependencyFileBuilder);
        this.sharedLibraries.add(dependencyFileBuilder);
        return this.getThis();
    }

    public T withGroupId(String groupId) {
        this.groupId = groupId;
        return this.getThis();
    }

    public T withVersion(String version) {
        this.version = version;
        return this.getThis();
    }

    public T withClassifier(String classifier) {
        this.classifier = classifier;
        return this.getThis();
    }

    public T withScope(String scope) {
        this.scope = scope;
        return this.getThis();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return "jar";
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public String getArtifactFileRepositoryPath() {
        return this.getGroupId().replace(".", File.separator) + File.separator + Paths.get(this.getArtifactId(), this.getVersion(), this.getArtifactId() + "-" + this.getVersion() + (this.getClassifier() != null ? "-" + this.getClassifier() : "") + "." + "jar").toString();
    }

    public String getArtifactFileRepositoryFolderPath() {
        return this.getGroupId().replace(".", File.separator) + File.separator + Paths.get(this.getArtifactId(), this.getVersion()).toString();
    }

    public String getArtifactFilePomRepositoryPath() {
        return this.getGroupId().replace(".", File.separator) + File.separator + Paths.get(this.getArtifactId(), this.getVersion(), this.getArtifactId() + "-" + this.getVersion() + ".pom").toString();
    }

    public String getArtifactFileBundledPomPartialUrl() {
        return "META-INF/maven/" + this.getGroupId() + "/" + this.getArtifactId() + "/pom.xml";
    }

    public String getArtifactFileBundledPomPropertiesPartialUrl() {
        return "META-INF/maven/" + this.getGroupId() + "/" + this.getArtifactId() + "/pom.properties";
    }

    public BundleDependency getAsMavenDependency() {
        BundleDescriptor bundleDescriptor = new BundleDescriptor.Builder().setVersion(this.getVersion()).setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setClassifier(this.getClassifier()).setType(this.getType()).build();
        return new BundleDependency.Builder().setBundleDescriptor(bundleDescriptor).setScope(BundleScope.valueOf((String)Optional.ofNullable(this.getScope()).orElse(BundleScope.COMPILE.name()))).build();
    }

    protected abstract T getThis();

    public List<AbstractDependencyFileBuilder> getDependencies() {
        return this.dependencies;
    }

    public List<AbstractDependencyFileBuilder> getAllCompileDependencies() {
        HashSet<AbstractDependencyFileBuilder> allCompileDependencies = new HashSet<AbstractDependencyFileBuilder>();
        for (AbstractDependencyFileBuilder dependency : this.dependencies) {
            if (!dependency.getAsMavenDependency().getScope().equals((Object)BundleScope.COMPILE)) continue;
            allCompileDependencies.addAll(dependency.getAllCompileDependencies());
            allCompileDependencies.add(dependency);
        }
        return new ArrayList<AbstractDependencyFileBuilder>(allCompileDependencies);
    }

    public List<AbstractDependencyFileBuilder> getAllClassLoaderModelDependencies() {
        HashSet<AbstractDependencyFileBuilder> allClassLoaderModelDependencies = new HashSet<AbstractDependencyFileBuilder>(this.dependencies);
        for (AbstractDependencyFileBuilder dependency : this.dependencies) {
            if (dependency.getClassifier() == null || !dependency.getClassifier().equals(MULE_PLUGIN_CLASSIFIER)) continue;
            allClassLoaderModelDependencies.addAll(this.getAllPluginDependencies(dependency));
        }
        return new ArrayList<AbstractDependencyFileBuilder>(allClassLoaderModelDependencies);
    }

    private List<AbstractDependencyFileBuilder> getAllPluginDependencies(AbstractDependencyFileBuilder dependency) {
        HashSet allPluginDependencies = new HashSet();
        dependency.getDependencies().forEach(td -> {
            AbstractDependencyFileBuilder transitiveDependency = (AbstractDependencyFileBuilder)td;
            if (transitiveDependency.getClassifier() != null && transitiveDependency.getClassifier().equals(MULE_PLUGIN_CLASSIFIER)) {
                allPluginDependencies.add(transitiveDependency);
                allPluginDependencies.addAll(this.getAllPluginDependencies(transitiveDependency));
            }
        });
        return new ArrayList<AbstractDependencyFileBuilder>(allPluginDependencies);
    }

    protected boolean isShared(AbstractDependencyFileBuilder dependencyFileBuilder) {
        return this.sharedLibraries.contains(dependencyFileBuilder);
    }
}

