/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.core.internal.serialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.datetime.DateTime;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

public abstract class AbstractSerializerProtocolContractTestCase
extends AbstractMuleContextTestCase {
    private static final String STRING_MESSAGE = "Hello World";
    protected SerializationProtocol serializationProtocol;

    @Test(expected=IllegalArgumentException.class)
    public final void nullBytes() throws Exception {
        this.serializationProtocol.deserialize((byte[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void nullStream() throws Exception {
        this.serializationProtocol.deserialize((InputStream)null);
    }

    @Test
    public final void nullObject() throws Exception {
        byte[] bytes = this.serializationProtocol.serialize(null);
        Object object = this.serializationProtocol.deserialize(bytes);
        junit.framework.Assert.assertNull((Object)object);
    }

    @Test
    public final void inputStreamClosed() throws Exception {
        byte[] bytes = this.serializationProtocol.serialize((Object)STRING_MESSAGE);
        InputStream inputStream = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(bytes));
        String output = (String)this.serializationProtocol.deserialize(inputStream);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        Assert.assertThat((Object)output, (Matcher)CoreMatchers.equalTo((Object)STRING_MESSAGE));
    }

    @Test
    public final void serializeWithoutDefaultConstructor() throws Exception {
        Calendar calendar = Calendar.getInstance();
        Locale locale = Locale.ITALIAN;
        DateTime dateTime = new DateTime(calendar, locale);
        dateTime.changeTimeZone("Pacific/Midway");
        CoreEvent event = MuleContextUtils.eventBuilder(muleContext).message(Message.of((Object)dateTime)).build();
        byte[] bytes = this.serializationProtocol.serialize((Object)event.getMessage());
        InternalMessage message = (InternalMessage)this.serializationProtocol.deserialize(bytes);
        DateTime deserealized = (DateTime)message.getPayload().getValue();
        junit.framework.Assert.assertEquals((Object)calendar, (Object)deserealized.toCalendar());
        junit.framework.Assert.assertEquals((String)dateTime.format(), (String)deserealized.format());
    }
}

