/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit5;

import java.io.Closeable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mule.tck.junit5.ClassLoaderCleanup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderCleanupExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderCleanupExtension.class);
    private final ConcurrentHashMap<Object, ClassLoader> originalInstanceClassLoaders = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, ClassLoader> originalStaticClassLoaders = new ConcurrentHashMap();

    public void beforeEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getTestInstance().orElse(null);
        if (testInstance != null) {
            this.originalInstanceClassLoaders.put(testInstance, Thread.currentThread().getContextClassLoader());
            LOGGER.debug("Stored original context classloader for test: {}", (Object)context.getDisplayName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getTestInstance().orElse(null);
        if (testInstance == null) {
            return;
        }
        try {
            this.cleanupClassLoaderFields(testInstance.getClass(), testInstance, false);
        }
        finally {
            ClassLoader originalClassLoader = this.originalInstanceClassLoaders.remove(testInstance);
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                LOGGER.debug("Restored original context classloader for test: {}", (Object)context.getDisplayName());
            }
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        this.originalStaticClassLoaders.put(testClass, Thread.currentThread().getContextClassLoader());
        LOGGER.debug("Stored original context classloader for test class: {}", (Object)testClass.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        try {
            this.cleanupClassLoaderFields(testClass, null, true);
        }
        finally {
            ClassLoader originalClassLoader = this.originalStaticClassLoaders.remove(testClass);
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                LOGGER.debug("Restored original context classloader for test class: {}", (Object)testClass.getSimpleName());
            }
        }
    }

    private void cleanupClassLoaderFields(Class<?> testClass, Object testInstance, boolean processStatic) {
        try {
            for (Class<?> currentClass = testClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Field field : currentClass.getDeclaredFields()) {
                    if (!this.shouldCleanupField(field, processStatic)) continue;
                    this.cleanupField(testInstance, field);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error during classloader field cleanup", (Throwable)e);
        }
    }

    private boolean shouldCleanupField(Field field, boolean processStatic) {
        return field.isAnnotationPresent(ClassLoaderCleanup.class) && Modifier.isStatic(field.getModifiers()) == processStatic;
    }

    private void cleanupField(Object testInstance, Field field) {
        field.setAccessible(true);
        try {
            Object fieldValue = field.get(testInstance);
            if (fieldValue instanceof Closeable) {
                Closeable closeable = (Closeable)fieldValue;
                closeable.close();
                LOGGER.debug("Closed annotated Closeable field '{}': {}", (Object)field.getName(), (Object)fieldValue.getClass().getSimpleName());
            } else if (fieldValue != null) {
                LOGGER.debug("Skipped non-Closeable field '{}': {}", (Object)field.getName(), (Object)fieldValue.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to cleanup annotated classloader field: {}", (Object)field.getName(), (Object)e);
        }
    }
}

