/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.test.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.SystemUtils;

public class TestFileUtils {
    public static boolean isFileOpen(File file) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return TestFileUtils.isFileOpenWindows(file);
        }
        return TestFileUtils.isFileOpenUnix(file);
    }

    static boolean isFileOpenUnix(File file) {
        String filePath = file.getAbsolutePath();
        File nullFile = new File("/dev/null");
        ProcessBuilder builder = new ProcessBuilder("lsof", "-c", "java", "-a", "-T", "--", filePath).redirectError(nullFile).redirectOutput(nullFile);
        try {
            Process process = builder.start();
            int exitValue = process.waitFor();
            return exitValue == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    static boolean isFileOpenWindows(File file) {
        URI fileURI = file.toURI();
        File sameFileName = new File(fileURI);
        return !file.renameTo(sameFileName);
    }
}

