/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUnitTestSupportLifecycleSchedulerDecorator
implements Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleUnitTestSupportLifecycleSchedulerDecorator.class);
    private String name;
    private Scheduler decorated;
    private SimpleUnitTestSupportSchedulerService ownerService;
    private boolean stopped;
    private Collection<ScheduledFuture> recurrentTasks = new LinkedList<ScheduledFuture>();
    private static Field threadLocalsField;

    public SimpleUnitTestSupportLifecycleSchedulerDecorator(String name, Scheduler decorated, SimpleUnitTestSupportSchedulerService ownerService) {
        this.name = name;
        this.decorated = decorated;
        this.ownerService = ownerService;
    }

    public void stop() {
        this.cancelStillActiveTasks();
        this.stopped = true;
        this.decorated.stop();
        this.ownerService.stoppedScheduler(this);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.decorated.schedule(this.wrap(command), delay, unit);
    }

    public void execute(Runnable command) {
        this.decorated.execute(this.wrap(command));
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.decorated.schedule(this.wrap(callable), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        ScheduledFuture recurrentTask = this.decorated.scheduleAtFixedRate(this.wrap(command), initialDelay, period, unit);
        this.recurrentTasks.add(recurrentTask);
        return recurrentTask;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledFuture recurrentTask = this.decorated.scheduleWithFixedDelay(this.wrap(command), initialDelay, delay, unit);
        this.recurrentTasks.add(recurrentTask);
        return recurrentTask;
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression) {
        ScheduledFuture recurrentTask = this.decorated.scheduleWithCronExpression(this.wrap(command), cronExpression);
        this.recurrentTasks.add(recurrentTask);
        return recurrentTask;
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression, TimeZone timeZone) {
        ScheduledFuture recurrentTask = this.decorated.scheduleWithCronExpression(this.wrap(command), cronExpression, timeZone);
        this.recurrentTasks.add(recurrentTask);
        return recurrentTask;
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.decorated.submit(this.wrap(task));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.decorated.submit(this.wrap(task), result);
    }

    public Future<?> submit(Runnable task) {
        return this.decorated.submit(this.wrap(task));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.decorated.invokeAll((Collection)tasks.stream().map(t -> this.wrap((Callable)t)).collect(Collectors.toList()));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.decorated.invokeAll((Collection)tasks.stream().map(t -> this.wrap((Callable)t)).collect(Collectors.toList()), timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.decorated.invokeAny((Collection)tasks.stream().map(t -> this.wrap((Callable)t)).collect(Collectors.toList()));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.decorated.invokeAny((Collection)tasks.stream().map(t -> this.wrap((Callable)t)).collect(Collectors.toList()), timeout, unit);
    }

    protected static void clearAllThreadLocals() {
        try {
            threadLocalsField.set(Thread.currentThread(), null);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Runnable wrap(Runnable command) {
        return () -> {
            try {
                command.run();
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException || t.getCause() instanceof InterruptedException) {
                    LOGGER.info(String.format("Task '%s' interrupted in test scheduler '%s'", command.toString(), this.decorated.getName()));
                    Thread.currentThread().interrupt();
                } else {
                    LOGGER.error(String.format("Task '%s' finished with exception in test scheduler '%s'", command.toString(), this.decorated.getName()), t);
                }
            }
            finally {
                SimpleUnitTestSupportLifecycleSchedulerDecorator.clearAllThreadLocals();
            }
        };
    }

    private <V> Callable<V> wrap(Callable<V> callable) {
        return () -> {
            try {
                Object v = callable.call();
                return v;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException || t.getCause() instanceof InterruptedException) {
                    LOGGER.info(String.format("Task '%s' interrupted in test scheduler '%s'", callable.toString(), this.decorated.getName()));
                    Thread.currentThread().interrupt();
                } else {
                    LOGGER.error(String.format("Task '%s' finished with exception in test scheduler '%s'", callable.toString(), this.decorated.getName()), t);
                }
                Object var3_4 = null;
                return var3_4;
            }
            finally {
                SimpleUnitTestSupportLifecycleSchedulerDecorator.clearAllThreadLocals();
            }
        };
    }

    protected void cancelStillActiveTasks() {
        List<ScheduledFuture> stillaCtiveRecurrentTasks = this.recurrentTasks.stream().filter(recurrentTask -> !recurrentTask.isDone() && !recurrentTask.isCancelled()).collect(Collectors.toList());
        if (!stillaCtiveRecurrentTasks.isEmpty()) {
            LOGGER.warn("Scheduler '" + this.name + "' stopped while it still has active recurrent tasks:" + stillaCtiveRecurrentTasks.toString());
        }
        stillaCtiveRecurrentTasks.forEach(recurrentTask -> recurrentTask.cancel(true));
    }

    public void shutdown() {
        this.stopped = true;
        this.decorated.shutdown();
        this.ownerService.stoppedScheduler(this);
    }

    public List<Runnable> shutdownNow() {
        this.cancelStillActiveTasks();
        this.stopped = true;
        List cancelledJobs = this.decorated.shutdownNow();
        this.ownerService.stoppedScheduler(this);
        return cancelledJobs;
    }

    public boolean isShutdown() {
        return this.stopped || this.decorated.isShutdown();
    }

    public boolean isTerminated() {
        return this.decorated.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.decorated.awaitTermination(timeout, unit);
    }

    public String getName() {
        return SimpleUnitTestSupportLifecycleSchedulerDecorator.class.getSimpleName() + ":" + this.decorated.getName() + "(" + this.name + ")";
    }

    public String toString() {
        return this.getName();
    }

    public Scheduler getDecorated() {
        return this.decorated;
    }

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

