/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractReactiveProcessorTestCase
extends AbstractMuleContextTestCase {
    protected Scheduler scheduler;
    protected Mode mode;
    protected ConfigurationComponentLocator configurationComponentLocator = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    public AbstractReactiveProcessorTestCase(Mode mode) {
        this.mode = mode;
    }

    @Parameterized.Parameters
    public static Collection<Mode> modeParameters() {
        return Arrays.asList(Mode.BLOCKING, Mode.NON_BLOCKING);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.scheduler = muleContext.getSchedulerService().cpuIntensiveScheduler();
    }

    @Override
    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(new ConfigurationBuilder(){

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }

            public void configure(MuleContext muleContext) throws ConfigurationException {
                try {
                    muleContext.getRegistry().registerObject("_muleConfigurationComponentLocator", (Object)AbstractReactiveProcessorTestCase.this.configurationComponentLocator);
                }
                catch (RegistrationException e) {
                    throw new ConfigurationException((Throwable)e);
                }
            }

            public boolean isConfigured() {
                return true;
            }
        });
    }

    @Override
    protected void doTearDown() throws Exception {
        this.scheduler.stop();
        super.doTearDown();
    }

    @Override
    protected InternalEvent process(Processor processor, InternalEvent event) throws Exception {
        return this.process(processor, event, true);
    }

    protected InternalEvent process(Processor processor, InternalEvent event, boolean unwrapMessagingException) throws Exception {
        LifecycleUtils.setMuleContextIfNeeded((Object)processor, (MuleContext)muleContext);
        try {
            switch (this.mode) {
                case BLOCKING: {
                    return processor.process(event);
                }
                case NON_BLOCKING: {
                    return MessageProcessors.processToApply((InternalEvent)event, (ReactiveProcessor)processor);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (unwrapMessagingException && !(processor instanceof Flow) && exception instanceof MessagingException) {
                throw this.messagingExceptionToException((MessagingException)((Object)exception));
            }
            throw exception;
        }
    }

    private Exception messagingExceptionToException(MessagingException msgException) {
        return msgException.getCause() instanceof Exception ? (Exception)msgException.getCause() : new RuntimeException(msgException.getCause());
    }

    public static enum Mode {
        BLOCKING,
        NON_BLOCKING;

    }
}

