/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.classlaoder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.core.internal.util.EnumerationAdapter;

public class TestClassLoader
extends ClassLoader {
    private Map<String, Class> classes = new HashMap<String, Class>();
    private Map<String, URL> resources = new HashMap<String, URL>();
    private Map<String, InputStream> streamResources = new HashMap<String, InputStream>();
    private Map<String, String> libraries = new HashMap<String, String>();

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class aClass = this.classes.get(name);
        if (aClass == null) {
            throw new TestClassNotFoundException(name, this);
        }
        return aClass;
    }

    @Override
    public URL getResource(String s) {
        return this.resources.get(s);
    }

    @Override
    public InputStream getResourceAsStream(String s) {
        return this.streamResources.get(s);
    }

    @Override
    public Enumeration<URL> getResources(String s) throws IOException {
        return this.findResources(s);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return new EnumerationAdapter(this.resources.values());
    }

    @Override
    protected URL findResource(String s) {
        return this.resources.get(s);
    }

    @Override
    protected String findLibrary(String s) {
        return this.libraries.get(s);
    }

    public void addClass(String className, Class aClass) {
        this.classes.put(className, aClass);
    }

    public void addResource(String resourceName, URL resourceUrl) {
        this.resources.put(resourceName, resourceUrl);
    }

    public void addStreamResource(String resourceName, InputStream resourceStream) {
        this.streamResources.put(resourceName, resourceStream);
    }

    public void addLibrary(String libraryName, String libraryPath) {
        this.libraries.put(libraryName, libraryPath);
    }

    @Override
    protected synchronized Class<?> loadClass(String s, boolean b) throws ClassNotFoundException {
        return this.loadClass(s);
    }

    public static class TestClassNotFoundException
    extends ClassNotFoundException {
        private ClassLoader classLoader;

        public TestClassNotFoundException(String s, ClassLoader classLoader) {
            super(s);
            this.classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

