/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.DisableOnDebug;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.rule.WarningTimeout;
import org.mule.tck.util.MuleContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleTestCase {
    public static final String TEST_PAYLOAD = "test";
    public static final String TEST_CONNECTOR = "test";
    public static final ComponentLocation TEST_CONNECTOR_LOCATION = DefaultComponentLocation.fromSingleComponent((String)"test");
    public static final String TESTING_MODE_PROPERTY_NAME = "mule.testingMode";
    public static final int DEFAULT_TEST_TIMEOUT_SECS = 60;
    public static final String TEST_TIMEOUT_SYSTEM_PROPERTY = "mule.test.timeoutSecs";
    private static final boolean verbose;
    private static final Logger LOGGER;
    private boolean offline = "true".equalsIgnoreCase(System.getProperty("org.mule.offline"));
    private int testTimeoutSecs = this.getTimeoutSystemProperty();
    @Rule
    public TestName name = new TestName();
    @Rule
    public TestRule globalTimeout = this.createTestTimeoutRule();
    private static String testCaseName;
    private Event _testEvent;
    private Event _nullPayloadEvent;
    private static final transient String THREAD_RESULT_LINE;

    protected TestRule createTestTimeoutRule() {
        int millisecondsTimeout = this.getTestTimeoutSecs() * 1000;
        if (this.isFailOnTimeout()) {
            return new DisableOnDebug((TestRule)new Timeout(millisecondsTimeout));
        }
        return new WarningTimeout(millisecondsTimeout);
    }

    protected int getTimeoutSystemProperty() {
        String timeoutString = System.getProperty(TEST_TIMEOUT_SYSTEM_PROPERTY, null);
        if (timeoutString == null) {
            String variableName = TEST_TIMEOUT_SYSTEM_PROPERTY.toUpperCase().replace(".", "_");
            timeoutString = System.getenv(variableName);
        }
        int result = 60;
        if (timeoutString != null) {
            try {
                result = Integer.parseInt(timeoutString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected boolean isDisabledInThisEnvironment() {
        return false;
    }

    protected boolean isDisabledInThisEnvironment(String testMethodName) {
        return false;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            LOGGER.warn(StringMessageUtils.getBoilerPlate((String)("Working offline cannot run test: " + method), (char)'=', (int)80));
        }
        return this.offline;
    }

    public int getTestTimeoutSecs() {
        return this.testTimeoutSecs;
    }

    protected static String getMavenProjectVersionProperty() {
        return System.getProperty("maven.projectVersion");
    }

    @Before
    public final void initializeMuleTest() {
        this.skipTestWhenDisabledInCurrentEnvironment();
        this.printTestHeader();
    }

    private void printTestHeader() {
        if (verbose) {
            System.out.println(StringMessageUtils.getBoilerPlate((String)this.getTestHeader(), (char)'=', (int)80));
        }
    }

    protected String getTestHeader() {
        return "Testing: " + this.name.getMethodName();
    }

    private void skipTestWhenDisabledInCurrentEnvironment() {
        Assume.assumeThat((Object)this, (Matcher)new BaseMatcher<AbstractMuleTestCase>(){

            public boolean matches(Object o) {
                return !AbstractMuleTestCase.this.isDisabledInThisEnvironment() && !AbstractMuleTestCase.this.isDisabledInThisEnvironment(AbstractMuleTestCase.this.name.getMethodName());
            }

            public void describeTo(Description description) {
                description.appendText("Test " + AbstractMuleTestCase.this.name.getMethodName() + " disabled in this environment");
            }
        });
    }

    protected boolean isFailOnTimeout() {
        return true;
    }

    @After
    public final void clearRequestContext() {
        Event.setCurrentEvent(null);
    }

    protected static List<String> collectThreadNames() {
        ArrayList<String> threadNames = new ArrayList<String>();
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.isAlive()) continue;
            threadNames.add(t.getName() + " - " + t.getId());
        }
        Collections.sort(threadNames);
        return threadNames;
    }

    @BeforeClass
    public static void clearTestCaseName() {
        testCaseName = null;
    }

    @Before
    public void takeTestCaseName() {
        if (testCaseName == null) {
            testCaseName = this.getClass().getName();
        }
    }

    protected Event testEvent() throws MuleException {
        if (this._testEvent == null) {
            this._testEvent = this.newEvent();
        }
        return this._testEvent;
    }

    protected Event newEvent() throws MuleException {
        return this.getEventBuilder().message(Message.of((Object)"test")).build();
    }

    protected Event.Builder getEventBuilder() throws MuleException {
        return MuleContextUtils.eventBuilder();
    }

    protected Event nullPayloadEvent() throws MuleException {
        if (this._nullPayloadEvent == null) {
            this._nullPayloadEvent = MuleContextUtils.eventBuilder().message(Message.of(null)).build();
        }
        return this._nullPayloadEvent;
    }

    @After
    public void clearTestEvents() throws MuleException {
        this._testEvent = null;
        this._nullPayloadEvent = null;
    }

    @AfterClass
    public static void dumpFilteredThreadsInTest() {
        List<String> currentThreads = AbstractMuleTestCase.collectThreadNames();
        int filteredThreads = 0;
        StringBuilder builder = new StringBuilder();
        for (String threadName : currentThreads) {
            if (AbstractMuleTestCase.nameIn(threadName, "[MuleRuntime]", "Finalizer", "Monitor Ctrl-Break", "Reference Handler", "Signal Dispatcher", "main")) continue;
            builder.append("\n-> ").append(threadName);
            ++filteredThreads;
        }
        if (filteredThreads > 0) {
            AbstractMuleTestCase.logThreadsResult(String.format("Hung threads count: %d. Test case: %s. Thread names:%s", filteredThreads, testCaseName, builder.toString()));
        } else {
            AbstractMuleTestCase.logThreadsResult(String.format("No hung threads. Test case: %s", testCaseName));
        }
    }

    private static boolean nameIn(String threadName, String ... values) {
        String threadNameLowercase = threadName.toLowerCase();
        if (values != null) {
            for (String value : values) {
                if (!threadNameLowercase.startsWith(value.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private static void logThreadsResult(String result) {
        LOGGER.warn(String.format("\n%s\n%s\n%s\n", THREAD_RESULT_LINE, result, THREAD_RESULT_LINE));
    }

    static {
        String muleOpts = SystemUtils.getenv((String)"MULE_TEST_OPTS");
        if (!StringUtils.isBlank((String)muleOpts)) {
            Map parsedOpts = SystemUtils.parsePropertyDefinitions((String)muleOpts);
            String optVerbose = (String)parsedOpts.get("mule.verbose");
            verbose = Boolean.valueOf(optVerbose);
        } else {
            verbose = true;
        }
        System.setProperty(TESTING_MODE_PROPERTY_NAME, "");
        LOGGER = LoggerFactory.getLogger(AbstractMuleTestCase.class);
        THREAD_RESULT_LINE = StringUtils.repeat((char)'-', (int)80);
    }
}

