/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.util.Optional;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.InternalEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.NotificationDispatcher;
import org.mule.runtime.core.api.context.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleContextUtils {
    private MuleContextUtils() {
    }

    public static MuleContext mockMuleContext() {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)muleContext.getUniqueIdString()).thenReturn((Object)UUID.getUUID());
        Mockito.when((Object)muleContext.getDefaultErrorHandler(Optional.empty())).thenReturn((Object)new OnErrorPropagateHandler());
        StreamingManager streamingManager = (StreamingManager)Mockito.mock(StreamingManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        try {
            MuleRegistry registry = muleContext.getRegistry();
            ((MuleRegistry)Mockito.doReturn((Object)streamingManager).when((Object)registry)).lookupObject(StreamingManager.class);
            ((MuleRegistry)Mockito.doReturn((Object)Mockito.mock(NotificationDispatcher.class)).when((Object)registry)).lookupObject(NotificationDispatcher.class);
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
        return muleContext;
    }

    public static MuleContext mockContextWithServices() {
        MuleContext muleContext = MuleContextUtils.mockMuleContext();
        Mockito.when((Object)muleContext.getSchedulerService()).thenReturn(Mockito.spy((Object)new SimpleUnitTestSupportSchedulerService()));
        MuleContextUtils.mockNotificationsHandling(muleContext.getRegistry());
        return muleContext;
    }

    public static void mockNotificationsHandling(MuleRegistry registry) {
        try {
            Mockito.when((Object)registry.lookupObject(NotificationDispatcher.class)).thenReturn(Mockito.mock(NotificationDispatcher.class));
            Mockito.when((Object)registry.lookupObject(NotificationListenerRegistry.class)).thenReturn(Mockito.mock(NotificationListenerRegistry.class));
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static InternalEvent.Builder eventBuilder() throws MuleException {
        Flow flowConstruct = MuleTestUtils.getTestFlow(MuleContextUtils.mockContextWithServices());
        return InternalEvent.builder((InternalEventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (ComponentLocation)AbstractMuleTestCase.TEST_CONNECTOR_LOCATION));
    }
}

