/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.probe;

import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.tck.probe.Timeout;

public class PollingProber
implements Prober {
    public static final long DEFAULT_TIMEOUT = 1000L;
    public static final long DEFAULT_POLLING_INTERVAL = 100L;
    private final long timeoutMillis;
    private final long pollDelayMillis;

    public static void check(long timeoutMillis, long pollDelayMillis, CheckedSupplier<Boolean> probe) {
        new PollingProber(timeoutMillis, pollDelayMillis).check(new JUnitLambdaProbe(probe));
    }

    public PollingProber() {
        this(1000L, 100L);
    }

    public PollingProber(long timeoutMillis, long pollDelayMillis) {
        this.timeoutMillis = timeoutMillis;
        this.pollDelayMillis = pollDelayMillis;
    }

    public static void probe(CheckedSupplier<Boolean> probable) {
        PollingProber.probe(probable, (CheckedSupplier<String>)((CheckedSupplier)() -> null));
    }

    public static void probe(CheckedSupplier<Boolean> probable, CheckedSupplier<String> failureDescription) {
        new PollingProber().check(new JUnitLambdaProbe(probable, failureDescription));
    }

    public static void probe(CheckedSupplier<Boolean> probable, CheckedFunction<AssertionError, String> failureDescription) {
        new PollingProber().check(new JUnitLambdaProbe(probable, failureDescription));
    }

    public static void probe(long timeoutMillis, long pollDelayMillis, CheckedSupplier<Boolean> probable) {
        PollingProber.probe(timeoutMillis, pollDelayMillis, probable, (CheckedSupplier<String>)((CheckedSupplier)() -> null));
    }

    public static void probe(long timeoutMillis, long pollDelayMillis, CheckedSupplier<Boolean> probable, CheckedSupplier<String> failureDescription) {
        new PollingProber(timeoutMillis, pollDelayMillis).check(new JUnitLambdaProbe(probable, failureDescription));
    }

    public static void probe(long timeoutMillis, long pollDelayMillis, CheckedSupplier<Boolean> probable, CheckedFunction<AssertionError, String> failureDescription) {
        new PollingProber(timeoutMillis, pollDelayMillis).check(new JUnitLambdaProbe(probable, failureDescription));
    }

    @Override
    public void check(Probe probe) {
        if (!this.poll(probe)) {
            throw new AssertionError((Object)probe.describeFailure());
        }
    }

    private boolean poll(Probe probe) {
        Timeout timeout = new Timeout(this.timeoutMillis);
        while (!probe.isSatisfied()) {
            if (timeout.hasTimedOut()) {
                return false;
            }
            this.waitFor(this.pollDelayMillis);
        }
        return true;
    }

    private void waitFor(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unexpected interrupt", e);
        }
    }
}

