/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public final class MuleTestUtils {
    public static final String APPLE_SERVICE = "appleService";
    public static final String APPLE_FLOW = "appleFlow";

    public static Error createErrorMock(Exception exception) {
        Error errorMock = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)errorMock.getCause()).thenReturn((Object)exception);
        return errorMock;
    }

    public static Injector spyInjector(MuleContext muleContext) {
        Injector spy = (Injector)Mockito.spy((Object)muleContext.getInjector());
        ((DefaultMuleContext)muleContext).setInjector(spy);
        return spy;
    }

    public static Flow getTestFlow(MuleContext context) throws MuleException {
        return MuleTestUtils.createFlow(context, APPLE_FLOW);
    }

    public static Flow createFlow(MuleContext context, String flowName) throws MuleException {
        Flow flow = Flow.builder((String)flowName, (MuleContext)context).withDirectProcessingStrategyFactory().build();
        flow.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.fromSingleComponent((String)flowName)));
        return flow;
    }

    public static Flow createAndRegisterFlow(MuleContext context, String flowName, ConfigurationComponentLocator mockComponentLocator) throws MuleException {
        Flow flow = MuleTestUtils.createFlow(context, flowName);
        MuleRegistry registry = ((MuleContextWithRegistries)context).getRegistry();
        if (registry != null) {
            registry.registerFlowConstruct((FlowConstruct)flow);
        }
        Mockito.when((Object)mockComponentLocator.find(Location.builder().globalName(flowName).build())).thenReturn(Optional.of(flow));
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testWithSystemProperty(String propertyName, String propertyValue, TestCallback callback) throws Exception {
        assert (propertyName != null && callback != null);
        String originalPropertyValue = null;
        try {
            originalPropertyValue = propertyValue == null ? System.clearProperty(propertyName) : System.setProperty(propertyName, propertyValue);
            callback.run();
        }
        finally {
            if (originalPropertyValue == null) {
                System.clearProperty(propertyName);
            } else {
                System.setProperty(propertyName, originalPropertyValue);
            }
        }
    }

    public static void testWithSystemProperties(Map<String, String> properties, TestCallback callback) throws Exception {
        assert (properties != null && callback != null);
        HashMap<String, String> originalPropertyValues = new HashMap<String, String>();
        properties.forEach((propertyName, propertyValue) -> {
            if (propertyValue == null) {
                originalPropertyValues.put((String)propertyName, System.clearProperty(propertyName));
            } else {
                originalPropertyValues.put((String)propertyName, System.setProperty(propertyName, propertyValue));
            }
        });
        try {
            callback.run();
        }
        finally {
            originalPropertyValues.forEach((propertyName, originalPropertyValue) -> {
                if (originalPropertyValue == null) {
                    System.clearProperty(propertyName);
                } else {
                    System.setProperty(propertyName, originalPropertyValue);
                }
            });
        }
    }

    public static Thread getRunningThreadByName(String name) {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!thread.getName().equals(name)) continue;
            return thread;
        }
        return null;
    }

    public static List<FlowExceptionHandler> getExceptionListeners(FlowExceptionHandler exceptionHandler) {
        try {
            Method getExceptionListenersMethod = exceptionHandler.getClass().getMethod("getExceptionListeners", new Class[0]);
            Object exceptionListeners = getExceptionListenersMethod.invoke((Object)exceptionHandler, new Object[0]);
            return (List)exceptionListeners;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain exception listener for flow");
        }
    }

    public static interface TestCallback {
        public void run() throws Exception;
    }
}

