/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.transaction.XaTransaction;
import org.mule.runtime.core.transaction.XaTransactionFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractTxThreadAssociationTestCase
extends AbstractMuleContextTestCase {
    private TransactionManager tm;
    protected static final int TRANSACTION_TIMEOUT_SECONDS = 3;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        TransactionManagerFactory factory = this.getTransactionManagerFactory();
        this.tm = factory.create(muleContext.getConfiguration());
        Assert.assertNotNull((String)"Transaction Manager should be available.", (Object)this.tm);
        Assert.assertNull((String)"There should be no current transaction associated.", (Object)this.tm.getTransaction());
    }

    @Test
    public void testTxHandleCommitKeepsThreadAssociation() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        Assert.assertNotNull((String)"Transaction should have started.", (Object)tx);
        Assert.assertEquals((String)"TX should have been active", (long)0L, (long)tx.getStatus());
        tx.commit();
        tx = this.tm.getTransaction();
        Assert.assertNotNull((String)"Committing via TX handle should NOT disassociated TX from the current thread.", (Object)tx);
        Assert.assertEquals((String)"TX status should have been COMMITTED.", (long)3L, (long)tx.getStatus());
        Transaction suspended = this.tm.suspend();
        Assert.assertTrue((String)"Wrong TX suspended?.", (boolean)suspended.equals(tx));
        Assert.assertNull((String)"TX should've been disassociated from the thread.", (Object)this.tm.getTransaction());
        this.tm.resume(null);
        Assert.assertNull((Object)this.tm.getTransaction());
    }

    @Test
    public void testTxManagerCommitDissassociatesThread() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        Assert.assertNotNull((String)"Transaction should have started.", (Object)tx);
        Assert.assertEquals((String)"TX should have been active", (long)0L, (long)tx.getStatus());
        this.tm.commit();
        Assert.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)this.tm.getTransaction());
    }

    @Test
    public void testTxManagerRollbackDissassociatesThread() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        Assert.assertNotNull((String)"Transaction should have started.", (Object)tx);
        Assert.assertEquals((String)"TX should have been active", (long)0L, (long)tx.getStatus());
        this.tm.rollback();
        Assert.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)this.tm.getTransaction());
    }

    @Test
    public void testAlwaysBeginXaTransactionSuspendResume() throws Exception {
        muleContext.setTransactionManager(this.tm);
        Assert.assertNull((String)"There should be no current transaction associated.", (Object)this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        config.setFactory((TransactionFactory)new XaTransactionFactory());
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)config);
        MuleTransactionConfig nestedConfig = new MuleTransactionConfig(1);
        nestedConfig.setFactory((TransactionFactory)new XaTransactionFactory());
        executionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>((TransactionConfig)nestedConfig){
            final /* synthetic */ TransactionConfig val$nestedConfig;
            {
                this.val$nestedConfig = transactionConfig;
            }

            public Void process() throws Exception {
                TransactionalExecutionTemplate innerExecutionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)this.val$nestedConfig);
                final Transaction firstTx = AbstractTxThreadAssociationTestCase.this.tm.getTransaction();
                Assert.assertNotNull((Object)firstTx);
                Assert.assertEquals((long)firstTx.getStatus(), (long)0L);
                return (Void)innerExecutionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>(){

                    public Void process() throws Exception {
                        Transaction secondTx = AbstractTxThreadAssociationTestCase.this.tm.getTransaction();
                        Assert.assertNotNull((Object)secondTx);
                        Assert.assertEquals((long)firstTx.getStatus(), (long)0L);
                        Assert.assertEquals((long)secondTx.getStatus(), (long)0L);
                        try {
                            AbstractTxThreadAssociationTestCase.this.tm.resume(firstTx);
                            Assert.fail((String)"Second transaction must be active");
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        try {
                            Transaction currentTx = AbstractTxThreadAssociationTestCase.this.tm.suspend();
                            Assert.assertTrue((boolean)currentTx.equals(secondTx));
                            AbstractTxThreadAssociationTestCase.this.tm.resume(firstTx);
                            Assert.assertEquals((Object)firstTx, (Object)AbstractTxThreadAssociationTestCase.this.tm.getTransaction());
                            Assert.assertEquals((long)firstTx.getStatus(), (long)0L);
                            Assert.assertEquals((long)secondTx.getStatus(), (long)0L);
                            Transaction a = AbstractTxThreadAssociationTestCase.this.tm.suspend();
                            Assert.assertTrue((boolean)a.equals(firstTx));
                            AbstractTxThreadAssociationTestCase.this.tm.resume(secondTx);
                        }
                        catch (Exception e) {
                            Assert.fail((String)("Error: " + e));
                        }
                        return null;
                    }
                });
            }
        });
        Assert.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)this.tm.getTransaction());
    }

    @Test
    public void testNoneXaTransactionSuspendResume() throws Exception {
        muleContext.setTransactionManager(this.tm);
        Assert.assertNull((String)"There should be no current transaction associated.", (Object)this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        config.setFactory((TransactionFactory)new XaTransactionFactory());
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)config);
        MuleTransactionConfig nestedConfig = new MuleTransactionConfig(0);
        nestedConfig.setFactory((TransactionFactory)new XaTransactionFactory());
        executionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>((TransactionConfig)nestedConfig){
            final /* synthetic */ TransactionConfig val$nestedConfig;
            {
                this.val$nestedConfig = transactionConfig;
            }

            public Void process() throws Exception {
                TransactionalExecutionTemplate nestedExecutionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)this.val$nestedConfig);
                final Transaction firstTx = AbstractTxThreadAssociationTestCase.this.tm.getTransaction();
                Assert.assertNotNull((Object)firstTx);
                Assert.assertEquals((long)firstTx.getStatus(), (long)0L);
                return (Void)nestedExecutionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>(){

                    public Void process() throws Exception {
                        Transaction secondTx = AbstractTxThreadAssociationTestCase.this.tm.getTransaction();
                        Assert.assertNull((Object)secondTx);
                        Assert.assertEquals((long)firstTx.getStatus(), (long)0L);
                        try {
                            AbstractTxThreadAssociationTestCase.this.tm.resume(firstTx);
                            Assert.assertEquals((Object)firstTx, (Object)AbstractTxThreadAssociationTestCase.this.tm.getTransaction());
                            Assert.assertEquals((long)firstTx.getStatus(), (long)0L);
                            Transaction a = AbstractTxThreadAssociationTestCase.this.tm.suspend();
                            Assert.assertTrue((boolean)a.equals(firstTx));
                        }
                        catch (Exception e) {
                            Assert.fail((String)("Error: " + e));
                        }
                        return null;
                    }
                });
            }
        });
        Assert.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)this.tm.getTransaction());
    }

    @Test
    public void testXaTransactionTermination() throws Exception {
        muleContext.setTransactionManager(this.tm);
        Assert.assertNull((String)"There should be no current transaction associated.", (Object)this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        XaTransaction muleTx = new XaTransaction(muleContext);
        Assert.assertFalse((boolean)muleTx.isBegun());
        Assert.assertEquals((long)6L, (long)muleTx.getStatus());
        muleTx.begin();
        Assert.assertTrue((boolean)muleTx.isBegun());
        muleTx.commit();
        Transaction jtaTx = this.tm.getTransaction();
        Assert.assertNull((String)"Committing via TX Manager should have disassociated TX from the current thread.", (Object)jtaTx);
        Assert.assertEquals((long)6L, (long)muleTx.getStatus());
    }

    @Test
    public void testNoNestedTxStarted() throws Exception {
        muleContext.setTransactionManager(this.tm);
        Assert.assertNull((String)"There should be no current transaction associated.", (Object)this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        MuleTransactionConfig config = new MuleTransactionConfig(1);
        config.setFactory((TransactionFactory)new XaTransactionFactory());
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)config);
        MuleTransactionConfig nestedConfig = new MuleTransactionConfig(2);
        nestedConfig.setFactory((TransactionFactory)new XaTransactionFactory());
        executionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>((TransactionConfig)nestedConfig){
            final /* synthetic */ TransactionConfig val$nestedConfig;
            {
                this.val$nestedConfig = transactionConfig;
            }

            public Void process() throws Exception {
                TransactionalExecutionTemplate nestedExecutionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)this.val$nestedConfig);
                return (Void)nestedExecutionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>(){

                    public Void process() throws Exception {
                        return null;
                    }
                });
            }
        });
    }

    protected TransactionManager getTransactionManager() {
        return this.tm;
    }

    protected abstract TransactionManagerFactory getTransactionManagerFactory();
}

