/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.tck.junit4.rule.SystemProperty;

public class TestConnectivityUtils {
    private static final Matcher NULL_VALUE = CoreMatchers.nullValue();
    private MuleContext muleContext;

    public TestConnectivityUtils(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void assertSuccessConnection(String configName) {
        this.assertConnection(configName, true, (Matcher<Exception>)NULL_VALUE, (Matcher<ErrorType>)NULL_VALUE);
    }

    public void assertFailedConnection(String configName, Matcher<Exception> exceptionMatcher, Matcher<ErrorType> errorTypeMatcher) {
        this.assertConnection(configName, false, exceptionMatcher, errorTypeMatcher);
    }

    public static SystemProperty disableAutomaticTestConnectivity() {
        return new SystemProperty("doTestConnectivity", "false");
    }

    private void assertConnection(String configName, boolean isSuccess, Matcher<Exception> exceptionMatcher, Matcher<ErrorType> codeMatcher) {
        ConnectivityTestingService testingService = (ConnectivityTestingService)this.muleContext.getRegistry().get("_muleConnectivityTestingService");
        ConnectionValidationResult validationResult = testingService.testConnection(configName);
        MatcherAssert.assertThat((Object)validationResult.isValid(), (Matcher)CoreMatchers.is((Object)isSuccess));
        if (!isSuccess) {
            MatcherAssert.assertThat((Object)validationResult.getException(), exceptionMatcher);
            MatcherAssert.assertThat(validationResult.getErrorType().orElse(null), codeMatcher);
        }
    }
}

