/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mule.runtime.core.util.ClassUtils;

public class ZipUtils {
    private ZipUtils() {
    }

    public static void compress(File targetFile, ZipResource[] resources) {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetFile));){
            for (ZipResource zipResource : resources) {
                URL resourceUrl = ClassUtils.getResource((String)zipResource.file, ZipUtils.class);
                if (resourceUrl == null) {
                    resourceUrl = new File(zipResource.file).toURI().toURL();
                }
                try (FileInputStream in = new FileInputStream(resourceUrl.getFile());){
                    int count;
                    out.putNextEntry(new ZipEntry(zipResource.alias == null ? zipResource.file : zipResource.alias));
                    byte[] buffer = new byte[1024];
                    while ((count = in.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class ZipResource {
        private final String file;
        private final String alias;

        public ZipResource(String file, String alias) {
            this.file = file;
            this.alias = alias;
        }
    }
}

