/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.scheduler.Scheduler;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

@RunWith(value=Parameterized.class)
public abstract class AbstractReactiveProcessorTestCase
extends AbstractMuleContextTestCase {
    protected Scheduler scheduler;
    private boolean reactive;

    public AbstractReactiveProcessorTestCase(boolean reactive) {
        this.reactive = reactive;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false}, {true});
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.scheduler = muleContext.getSchedulerService().cpuIntensiveScheduler();
    }

    @Override
    protected void doTearDown() throws Exception {
        this.scheduler.shutdownNow();
        super.doTearDown();
    }

    @Override
    protected Event process(Processor processor, Event event) throws Exception {
        try {
            if (this.reactive) {
                return MuleTestUtils.processAsStreamAndBlock(event, (Function<Publisher<Event>, Publisher<Event>>)processor);
            }
            return processor.process(event);
        }
        catch (MessagingException msgException) {
            throw msgException.getCause() instanceof Exception ? (Exception)msgException.getCause() : new RuntimeException(msgException.getCause());
        }
    }

    protected Event processFlow(Flow flow, Event event) throws Exception {
        if (this.reactive) {
            try {
                return (Event)Mono.just((Object)event).transform((Function)flow).subscribe().blockMillis(5000L);
            }
            catch (Throwable exception) {
                throw (Exception)Exceptions.unwrap((Throwable)exception);
            }
        }
        return flow.process(event);
    }

    protected boolean isReactive() {
        return this.reactive;
    }
}

