/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.scheduler.Scheduler;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.scheduler.ThreadType;
import org.mule.runtime.core.util.concurrent.NamedThreadFactory;
import org.mule.tck.SimpleUnitTestSupportLifecycleSchedulerDecorator;
import org.mule.tck.SimpleUnitTestSupportScheduler;

public class SimpleUnitTestSupportSchedulerService
implements SchedulerService,
Stoppable {
    private SimpleUnitTestSupportScheduler scheduler = new SimpleUnitTestSupportScheduler(8, (ThreadFactory)new NamedThreadFactory(SimpleUnitTestSupportScheduler.class.getSimpleName()), new ThreadPoolExecutor.AbortPolicy());
    private List<Scheduler> decorators = new ArrayList<Scheduler>();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Scheduler cpuLightScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler ioScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler cpuIntensiveScheduler() {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(this.scheduler);
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler customScheduler(String name, int corePoolSize) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(new SimpleUnitTestSupportScheduler(corePoolSize, (ThreadFactory)new NamedThreadFactory(name), new ThreadPoolExecutor.AbortPolicy()));
        this.decorators.add(decorator);
        return decorator;
    }

    public Scheduler customScheduler(String name, int corePoolSize, int queueSize) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator decorator = this.decorateScheduler(new SimpleUnitTestSupportScheduler(corePoolSize, (ThreadFactory)new NamedThreadFactory(name), new ThreadPoolExecutor.AbortPolicy()));
        this.decorators.add(decorator);
        return decorator;
    }

    protected SimpleUnitTestSupportLifecycleSchedulerDecorator decorateScheduler(SimpleUnitTestSupportScheduler scheduler) {
        SimpleUnitTestSupportLifecycleSchedulerDecorator spied = (SimpleUnitTestSupportLifecycleSchedulerDecorator)Mockito.spy((Object)new SimpleUnitTestSupportLifecycleSchedulerDecorator(scheduler));
        ((SimpleUnitTestSupportLifecycleSchedulerDecorator)Mockito.doReturn((Object)Mockito.mock(ScheduledFuture.class)).when((Object)spied)).scheduleWithCronExpression((Runnable)Matchers.any(), Matchers.anyString());
        ((SimpleUnitTestSupportLifecycleSchedulerDecorator)Mockito.doReturn((Object)Mockito.mock(ScheduledFuture.class)).when((Object)spied)).scheduleWithCronExpression((Runnable)Matchers.any(), Matchers.anyString(), (TimeZone)Matchers.any());
        return spied;
    }

    public void stop() throws MuleException {
        this.scheduler.shutdownNow();
    }

    public List<Scheduler> getCreatedSchedulers() {
        return Collections.unmodifiableList(this.decorators);
    }

    public void clearCreatedSchedulers() {
        this.decorators.clear();
    }

    public int getScheduledTasks() {
        return this.scheduler.getScheduledTasks();
    }

    public ThreadType currentThreadType() {
        return ThreadType.CUSTOM;
    }
}

