/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.Serializable;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.store.ObjectStore;
import org.mule.runtime.core.api.store.ObjectStoreException;
import org.mule.runtime.core.serialization.internal.JavaObjectSerializer;

public abstract class SerializationTestUtils {
    private static final String key = "SerializationTestComponentKey";

    public static <T extends Exception> T testException(T exception, MuleContext muleContext) {
        ObjectStore<T> os = SerializationTestUtils.getObjectStore(muleContext);
        try {
            os.store((Serializable)((Object)key), exception);
            Exception exception2 = (Exception)os.retrieve((Serializable)((Object)key));
            return (T)exception2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                os.clear();
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static <T extends Exception> ObjectStore<T> getObjectStore(MuleContext muleContext) {
        return muleContext.getObjectStoreManager().getObjectStore("SerializationTestUtils", true);
    }

    public static ObjectSerializer getJavaSerializerWithMockContext() {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)muleContext.getExecutionClassLoader()).thenReturn((Object)ObjectSerializer.class.getClassLoader());
        return SerializationTestUtils.getJavaSerializer(muleContext);
    }

    public static ObjectSerializer addJavaSerializerToMockMuleContext(MuleContext mockMuleContext) {
        ObjectSerializer objectSerializer = SerializationTestUtils.getJavaSerializer(mockMuleContext);
        Mockito.when((Object)mockMuleContext.getObjectSerializer()).thenReturn((Object)objectSerializer);
        return objectSerializer;
    }

    private static ObjectSerializer getJavaSerializer(MuleContext muleContext) {
        JavaObjectSerializer serializer = new JavaObjectSerializer();
        serializer.setMuleContext(muleContext);
        return serializer;
    }
}

