/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.function.Function;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.DefaultMuleContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.core.util.rx.Exceptions;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class MuleTestUtils {
    public static final String APPLE_SERVICE = "appleService";
    public static final String APPLE_FLOW = "appleFlow";

    public static Error createErrorMock(Exception exception) {
        Error errorMock = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)errorMock.getCause()).thenReturn((Object)exception);
        return errorMock;
    }

    public static Injector spyInjector(MuleContext muleContext) {
        Injector spy = (Injector)Mockito.spy((Object)muleContext.getInjector());
        ((DefaultMuleContext)muleContext).setInjector(spy);
        return spy;
    }

    public static Flow getTestFlow(MuleContext context) throws MuleException {
        Flow flow = new Flow(APPLE_FLOW, context);
        if (context.getRegistry() != null) {
            context.getRegistry().registerFlowConstruct((FlowConstruct)flow);
        }
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testWithSystemProperty(String propertyName, String propertyValue, TestCallback callback) throws Exception {
        assert (propertyName != null && callback != null);
        String originalPropertyValue = null;
        try {
            originalPropertyValue = propertyValue == null ? System.clearProperty(propertyName) : System.setProperty(propertyName, propertyValue);
            callback.run();
        }
        finally {
            if (originalPropertyValue == null) {
                System.clearProperty(propertyName);
            } else {
                System.setProperty(propertyName, originalPropertyValue);
            }
        }
    }

    public static Thread getRunningThreadByName(String name) {
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!thread.getName().equals(name)) continue;
            return thread;
        }
        return null;
    }

    public static Event processAsStreamAndBlock(Event event, Function<Publisher<Event>, Publisher<Event>> processor) throws MuleException {
        try {
            return (Event)Mono.just((Object)event).transform(processor).block();
        }
        catch (Throwable exception) {
            throw Exceptions.rxExceptionToMuleException((Throwable)exception);
        }
    }

    public static void processAsStream(Event event, Function<Publisher<Event>, Publisher<Event>> processor) throws MuleException {
        try {
            Mono.just((Object)event).transform(processor).subscribe();
        }
        catch (Throwable exception) {
            throw Exceptions.rxExceptionToMuleException((Throwable)exception);
        }
    }

    public static interface TestCallback {
        public void run() throws Exception;
    }
}

