/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.transformer.simple;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.activation.MimeTypeParseException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.metadata.DefaultTypedValue;
import org.mule.runtime.core.processor.simple.AbstractAddVariablePropertyProcessor;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
public abstract class AbstractAddVariablePropertyProcessorTestCase
extends AbstractMuleContextTestCase {
    public static final Charset ENCODING = StandardCharsets.US_ASCII;
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String PLAIN_STRING_VALUE = "someValue";
    public static final String EXPRESSION = "#[string:someValue]";
    public static final String EXPRESSION_VALUE = "expressionValueResult";
    public static final String NULL_EXPRESSION = "#[string:someValueNull]";
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_8;
    private Event event;
    private InternalMessage message;
    private MuleSession mockSession = (MuleSession)Mockito.mock(MuleSession.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExtendedExpressionManager mockExpressionManager = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
    private TypedValue mockTypedValue = (TypedValue)Mockito.mock(TypedValue.class);
    private AbstractAddVariablePropertyProcessor addVariableProcessor;

    public AbstractAddVariablePropertyProcessorTestCase(AbstractAddVariablePropertyProcessor abstractAddVariableProcessor) {
        this.addVariableProcessor = abstractAddVariableProcessor;
    }

    @Before
    public void setUpTest() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockMuleContext.getConfiguration()).thenReturn(Mockito.mock(MuleConfiguration.class));
        Mockito.when((Object)this.mockTypedValue.getValue()).thenReturn((Object)EXPRESSION_VALUE);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)EXPRESSION), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenReturn((Object)this.mockTypedValue);
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)EXPRESSION), (Event)Matchers.any(Event.class), (Event.Builder)Matchers.any(Event.Builder.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenReturn((Object)this.mockTypedValue);
        DefaultTypedValue typedValue = new DefaultTypedValue((Object)EXPRESSION_VALUE, DataType.STRING);
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)EXPRESSION), (Event)Matchers.any(Event.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenReturn((Object)typedValue);
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)EXPRESSION), (Event)Matchers.any(Event.class), (Event.Builder)Matchers.any(Event.Builder.class), (FlowConstruct)Matchers.any(FlowConstruct.class))).thenReturn((Object)typedValue);
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)EXPRESSION), (Event)Matchers.any(Event.class))).thenReturn((Object)typedValue);
        this.addVariableProcessor.setMuleContext(this.mockMuleContext);
        this.message = InternalMessage.builder().payload((Object)"").build();
        this.event = AbstractAddVariablePropertyProcessorTestCase.eventBuilder().message(this.message).session(this.mockSession).build();
    }

    @Test
    public void testAddVariable() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    @Test
    public void testAddVariableWithExpressionValue() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(EXPRESSION);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, EXPRESSION_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    @Test
    public void testAddVariableWithExpressionKey() throws MuleException {
        this.addVariableProcessor.setIdentifier(EXPRESSION);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, EXPRESSION_VALUE, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, EXPRESSION_VALUE), DataTypeMatcher.like(String.class, MediaType.ANY, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    @Test
    public void testAddVariableWithEncoding() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.addVariableProcessor.setReturnDataType(DataType.builder().charset(CUSTOM_ENCODING).build());
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.ANY, CUSTOM_ENCODING));
    }

    @Test
    public void testAddVariableWithMimeType() throws MimeTypeParseException, MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.addVariableProcessor.setReturnDataType(DataType.builder().mediaType(MediaType.APPLICATION_XML).build());
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyAdded(this.event, PLAIN_STRING_KEY, PLAIN_STRING_VALUE);
        Assert.assertThat((Object)this.getVariableDataType(this.event, PLAIN_STRING_KEY), DataTypeMatcher.like(String.class, MediaType.APPLICATION_XML, SystemUtils.getDefaultEncoding((MuleContext)this.mockMuleContext)));
    }

    protected abstract DataType getVariableDataType(Event var1, String var2);

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullKey() throws InitialisationException, TransformerException {
        this.addVariableProcessor.setIdentifier(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithEmptyKey() throws InitialisationException, TransformerException {
        this.addVariableProcessor.setIdentifier("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullValue() throws InitialisationException, TransformerException {
        this.addVariableProcessor.setValue(null);
    }

    @Test
    public void testAddVariableWithNullExpressionKeyResult() throws MuleException {
        TypedValue mockTypedValue = (TypedValue)Mockito.mock(TypedValue.class);
        Mockito.when((Object)mockTypedValue.getValue()).thenReturn(null);
        Mockito.when((Object)this.mockExpressionManager.evaluate(NULL_EXPRESSION, this.event)).thenReturn((Object)mockTypedValue);
        this.addVariableProcessor.setIdentifier(NULL_EXPRESSION);
        this.addVariableProcessor.setValue(PLAIN_STRING_VALUE);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyNotAdded(this.event);
    }

    @Test
    public void testAddVariableWithNullExpressionValueResult() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        DefaultTypedValue typedValue = new DefaultTypedValue(null, DataType.OBJECT);
        Mockito.when((Object)this.mockExpressionManager.evaluate(NULL_EXPRESSION, this.event)).thenReturn((Object)typedValue);
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)NULL_EXPRESSION), (Event)Matchers.eq((Object)this.event), (Event.Builder)Matchers.any(Event.Builder.class), (FlowConstruct)Matchers.eq(null))).thenReturn((Object)typedValue);
        this.addVariableProcessor.setValue(NULL_EXPRESSION);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, PLAIN_STRING_KEY);
    }

    @Test
    public void testAddVariableWithNullPayloadExpressionValueResult() throws MuleException {
        this.addVariableProcessor.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableProcessor.setValue(EXPRESSION);
        DefaultTypedValue typedValue = new DefaultTypedValue(null, DataType.OBJECT);
        Mockito.when((Object)this.mockExpressionManager.evaluate(EXPRESSION, this.event)).thenReturn((Object)typedValue);
        Mockito.when((Object)this.mockExpressionManager.evaluate((String)Matchers.eq((Object)EXPRESSION), (Event)Matchers.eq((Object)this.event), (Event.Builder)Matchers.any(Event.Builder.class), (FlowConstruct)Matchers.eq(null))).thenReturn((Object)typedValue);
        this.addVariableProcessor.initialise();
        this.event = this.addVariableProcessor.process(this.event);
        this.verifyRemoved(this.event, PLAIN_STRING_KEY);
    }

    protected abstract void verifyAdded(Event var1, String var2, String var3);

    protected abstract void verifyNotAdded(Event var1);

    protected abstract void verifyRemoved(Event var1, String var2);
}

