/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreePortFinder {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int minPortNumber;
    private final int portRange;
    private final Random random = new Random();
    private final String LOCK_FILE_EXTENSION = ".lock";
    private final Map<Integer, FileLock> locks = new HashMap<Integer, FileLock>();
    private final Map<Integer, FileChannel> files = new HashMap<Integer, FileChannel>();
    private final String basePath = System.getProperty("maven.multiModuleProjectDirectory", ".");

    public FreePortFinder(int minPortNumber, int maxPortNumber) {
        this.minPortNumber = minPortNumber;
        this.portRange = maxPortNumber - minPortNumber;
    }

    public synchronized Integer find() {
        for (int i = 0; i < this.portRange; ++i) {
            int port = this.minPortNumber + this.random.nextInt(this.portRange);
            String portFile = port + ".lock";
            try {
                FileChannel channel = FileChannel.open(Paths.get(this.basePath + SystemUtils.PATH_SEPARATOR + portFile, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
                FileLock lock = channel.tryLock();
                if (lock == null) {
                    throw new OverlappingFileLockException();
                }
                if (this.isPortFree(port)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found free port: " + port);
                    }
                    this.locks.put(port, lock);
                    this.files.put(port, channel);
                    return port;
                }
                lock.release();
                channel.close();
                continue;
            }
            catch (OverlappingFileLockException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Port selected already locked");
                continue;
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Error when trying to open port lock file, trying another port");
            }
        }
        throw new IllegalStateException("Unable to find an available port");
    }

    public synchronized void releasePort(int port) {
        if (this.isPortFree(port) && this.locks.containsKey(port) && this.files.containsKey(port)) {
            FileLock lock = this.locks.remove(port);
            FileChannel file = this.files.remove(port);
            try {
                lock.release();
                file.close();
            }
            catch (IOException iOException) {}
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("Port %d was not correctly released", port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortFree(int port) {
        boolean portIsFree = true;
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
            server.setReuseAddress(true);
        }
        catch (IOException e) {
            portIsFree = false;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException iOException) {}
            }
        }
        return portIsFree;
    }
}

