/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.config;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.http.api.HttpService;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;

public class TestServicesConfigurationBuilder
extends AbstractConfigurationBuilder
implements TestRule {
    private static final String MOCK_HTTP_SERVICE = "mockHttpService";
    private static final String MOCK_EXPR_EXECUTOR = "mockExpressionExecutor";
    private final SimpleUnitTestSupportSchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
    private boolean mockHttpService;
    private boolean mockExpressionExecutor;

    public TestServicesConfigurationBuilder() {
        this(true, true);
    }

    public TestServicesConfigurationBuilder(boolean mockHttpService, boolean mockExpressionExecutor) {
        this.mockHttpService = mockHttpService;
        this.mockExpressionExecutor = mockExpressionExecutor;
    }

    public void doConfigure(MuleContext muleContext) throws Exception {
        MuleRegistry registry = muleContext.getRegistry();
        registry.registerObject(this.schedulerService.getName(), Mockito.spy((Object)this.schedulerService));
        registry.registerObject("_muleSchedulerBaseConfig", (Object)SchedulerConfig.config());
        if (this.mockExpressionExecutor) {
            DefaultExpressionLanguageFactoryService expressionExecutor = (DefaultExpressionLanguageFactoryService)Mockito.mock(DefaultExpressionLanguageFactoryService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            registry.registerObject(MOCK_EXPR_EXECUTOR, (Object)expressionExecutor);
        } else {
            WeaveDefaultExpressionLanguageFactoryService exprExecutor = new WeaveDefaultExpressionLanguageFactoryService();
            registry.registerObject(exprExecutor.getName(), (Object)exprExecutor);
        }
        if (this.mockHttpService) {
            registry.registerObject(MOCK_HTTP_SERVICE, Mockito.mock(HttpService.class));
        }
    }

    public void stopServices() throws MuleException {
        List<Scheduler> schedulers = this.schedulerService.getSchedulers();
        try {
            Assert.assertThat(schedulers, (Matcher)IsEmptyCollection.empty());
        }
        finally {
            this.schedulerService.stop();
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    TestServicesConfigurationBuilder.this.stopServices();
                }
            }
        };
    }
}

