/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.artifact.internal.util.ServiceRegistryDescriptorLoaderRepository;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactoryProvider;
import org.mule.runtime.module.service.api.discoverer.MuleServiceModelLoader;
import org.mule.runtime.module.service.internal.artifact.ServiceDescriptorFactory;
import org.mule.test.runner.api.ArtifactClassificationNode;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.mule.test.runner.api.ServiceUrlClassification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResourcesResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceDescriptorFactory serviceDescriptorFactory;

    public ServiceResourcesResolver(final Collection<ArtifactClassificationNode> classificationNodes) {
        this.serviceDescriptorFactory = new ServiceDescriptorFactory((DescriptorLoaderRepository)new ServiceRegistryDescriptorLoaderRepository(), ArtifactDescriptorValidatorBuilder.builder()){

            protected BundleDescriptor getBundleDescriptor(File serviceFolder, MuleServiceModel artifactModel, Optional<Properties> deploymentProperties) {
                return classificationNodes.stream().filter(node -> {
                    try {
                        return node.getUrls().get(0).equals(serviceFolder.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).map(node -> new BundleDescriptor.Builder().setArtifactId(node.getArtifact().getArtifactId()).setGroupId(node.getArtifact().getGroupId()).setVersion(node.getArtifact().getVersion()).setBaseVersion(node.getArtifact().getVersion()).setType(node.getArtifact().getExtension()).setClassifier(node.getArtifact().getClassifier()).build()).findAny().get();
            }

            protected ClassLoaderConfiguration getClassLoaderConfiguration(File serviceFolder, Optional<Properties> deploymentProperties, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, BundleDescriptor bundleDescriptor) {
                try {
                    return (ClassLoaderConfiguration)ServiceClassLoaderFactoryProvider.serviceClassLoaderConfigurationLoader().load(serviceFolder, Collections.emptyMap(), this.getArtifactType());
                }
                catch (InvalidDescriptorLoaderException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }

    public ServiceUrlClassification resolveServiceResourcesFor(ArtifactUrlClassification serviceUrlClassification) {
        ServiceUrlClassification serviceUrlClassification2;
        URLClassLoader classLoader = new URLClassLoader(serviceUrlClassification.getUrls().toArray(new URL[0]), null);
        try {
            MuleServiceModel muleServiceModel = MuleServiceModelLoader.loadServiceModel((ClassLoader)classLoader);
            serviceUrlClassification2 = new ServiceUrlClassification(this.serviceDescriptorFactory.create(new File(serviceUrlClassification.getUrls().get(0).toURI()), Optional.empty()), serviceUrlClassification.getArtifactId(), "service/" + muleServiceModel.getName(), serviceUrlClassification.getUrls());
        }
        catch (Throwable throwable) {
            try {
                try {
                    classLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (URISyntaxException | ArtifactDescriptorCreateException e) {
                throw new IllegalArgumentException(e);
            }
        }
        classLoader.close();
        return serviceUrlClassification2;
    }
}

