/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.utils;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.test.runner.api.DependencyResolver;
import org.springframework.util.ReflectionUtils;

public final class RunnerModuleUtils {
    public static final String EXCLUDED_PROPERTIES_FILE = "excluded.properties";
    public static final String EXCLUDED_ARTIFACTS = "excluded.artifacts";
    public static final String EXTRA_BOOT_PACKAGES = "extraBoot.packages";
    public static final String JAR_EXTENSION = "jar";
    private static String DEFAULT_TEST_SDK_API_VERSION_PROPERTY = "mule.testSdkApiVersion";
    private static final String SDK_API_GROUP_ID = "org.mule.sdk";
    private static final String SDK_API_ARTIFACT_ID = "mule-sdk-api";
    private static final String DEFAULT_SDK_API_VERSION = RunnerModuleUtils.getDefaultSdkApiVersionForTest();
    private static final Artifact DEFAULT_SDK_API_ARTIFACT = new DefaultArtifact("org.mule.sdk", "mule-sdk-api", "jar", DEFAULT_SDK_API_VERSION);

    private RunnerModuleUtils() {
    }

    public static Properties getExcludedProperties() throws IllegalStateException, IOException {
        Properties excludedProperties = new Properties();
        PropertiesUtils.discoverProperties((String)EXCLUDED_PROPERTIES_FILE).stream().forEach(properties -> properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> excludedProperties.merge(k, v, (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(v1, v2) -> v1 + "," + v2)))));
        return excludedProperties;
    }

    public static Artifact getDefaultSdkApiArtifact() {
        return DEFAULT_SDK_API_ARTIFACT;
    }

    public static void assureSdkApiInClassLoader(ClassLoader extensionClassLoader, DependencyResolver dependencyResolver, List<RemoteRepository> repositories) {
        try {
            Class.forName("org.mule.sdk.api.runtime.parameter.ParameterResolver", true, extensionClassLoader);
        }
        catch (ClassNotFoundException cnf) {
            try {
                URL sdkApiUrl = dependencyResolver.resolveArtifact(RunnerModuleUtils.getDefaultSdkApiArtifact(), repositories).getArtifact().getFile().getAbsoluteFile().toURL();
                Method method = ReflectionUtils.findMethod(extensionClassLoader.getClass(), "addURL", URL.class);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)extensionClassLoader, sdkApiUrl);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not assure sdk-api in extension classloader", e);
            }
        }
    }

    private static String getDefaultSdkApiVersionForTest() {
        return System.getProperty(DEFAULT_TEST_SDK_API_VERSION_PROPERTY, "0.4.0");
    }
}

