/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.maven;

import java.io.File;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.mule.test.runner.maven.MavenModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArtifactFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactFactory.class);

    private ArtifactFactory() {
    }

    public static Artifact createFromPomFile(File pomFile) {
        LOGGER.debug("Reading rootArtifact from pom file: {}", (Object)pomFile);
        Model model = MavenModelFactory.createMavenProject(pomFile);
        return new DefaultArtifact(model.getGroupId() != null ? ArtifactFactory.searchingProperties(model, Model::getGroupId) : ArtifactFactory.searchingProperties(model, m -> m.getParent().getGroupId()), ArtifactFactory.searchingProperties(model, Model::getArtifactId), ArtifactFactory.searchingProperties(model, Model::getPackaging), model.getVersion() != null ? ArtifactFactory.searchingProperties(model, Model::getVersion) : ArtifactFactory.searchingProperties(model, m -> m.getParent().getVersion()));
    }

    private static String searchingProperties(Model model, Function<Model, String> extractor) {
        String value = extractor.apply(model);
        if (value.startsWith("${")) {
            String propertyKey = value.substring(value.indexOf("{") + 1, value.indexOf("}"));
            return model.getProperties().getProperty(propertyKey, value);
        }
        return value;
    }
}

