/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.provider.RuntimeExtensionModelProviderLoaderUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.extension.api.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.extension.api.manager.ExtensionManagerFactory;
import org.mule.test.runner.api.MulePluginBasedLoaderFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoaderExtensionsManagerConfigurationBuilder
extends AbstractConfigurationBuilder {
    private static final String META_INF_MULE_ARTIFACT_MULE_PLUGIN = "META-INF/mule-artifact/mule-artifact.json";
    private static Logger LOGGER = LoggerFactory.getLogger(IsolatedClassLoaderExtensionsManagerConfigurationBuilder.class);
    private final ExtensionManagerFactory extensionManagerFactory;
    private final List<ArtifactClassLoader> pluginsClassLoaders;
    private final List<ExtensionModel> extensionModels = new ArrayList<ExtensionModel>();

    public IsolatedClassLoaderExtensionsManagerConfigurationBuilder(List<ArtifactClassLoader> pluginsClassLoaders) {
        this.extensionManagerFactory = new DefaultExtensionManagerFactory();
        this.pluginsClassLoaders = pluginsClassLoaders;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        ExtensionManager extensionManager = this.createExtensionManager(muleContext);
        for (ExtensionModel extensionModel : this.extensionModels) {
            extensionManager.registerExtension(extensionModel);
        }
    }

    private ExtensionManager createExtensionManager(MuleContext muleContext) throws InitialisationException {
        if (muleContext.getExtensionManager() != null) {
            return muleContext.getExtensionManager();
        }
        ExtensionManager extensionManager = this.extensionManagerFactory.create(muleContext);
        muleContext.setExtensionManager(extensionManager);
        return extensionManager;
    }

    public void loadExtensionModels() {
        this.loadExtensionModels(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExtensionModels(Map<String, Object> extensionLoadingContextParameters) {
        this.extensionModels.clear();
        try {
            this.loadRuntimeExtensionModels().forEach(this.extensionModels::add);
            for (ArtifactClassLoader pluginClassLoader : this.pluginsClassLoaders) {
                String artifactName = (String)pluginClassLoader.getClass().getMethod("getArtifactId", new Class[0]).invoke((Object)pluginClassLoader, new Object[0]);
                ClassLoader classLoader = (ClassLoader)pluginClassLoader.getClass().getMethod("getClassLoader", new Class[0]).invoke((Object)pluginClassLoader, new Object[0]);
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                finally {
                    URL json = classLoader.getResource(META_INF_MULE_ARTIFACT_MULE_PLUGIN);
                    if (json == null) {
                        json = classLoader.getResource("META-INF/auto-generated-mule-artifact.json");
                    }
                    if (json != null) {
                        LOGGER.debug("Discovered extension '{}'", (Object)artifactName);
                        MulePluginBasedLoaderFinder finder = new MulePluginBasedLoaderFinder(json.openStream());
                        if (finder.isExtensionModelLoaderDescriptorDefined()) {
                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                            attributes.putAll(finder.getParams());
                            attributes.putAll(extensionLoadingContextParameters);
                            attributes.put("EXTENSION_LOADER_DISABLE_DESCRIPTIONS_ENRICHMENT", Boolean.TRUE);
                            ExtensionModel extension = finder.getLoader().loadExtensionModel(ExtensionModelLoadingRequest.builder((ClassLoader)classLoader, (DslResolvingContext)DslResolvingContext.getDefault(new HashSet<ExtensionModel>(this.extensionModels))).addParameters(attributes).build());
                            this.extensionModels.add(extension);
                        } else {
                            LOGGER.debug("Discarding plugin with artifactName '{}' as it doesn't have an ExtensionModelLoaderDescriptor defined", (Object)artifactName);
                        }
                    } else {
                        LOGGER.debug("Discarding plugin with artifactName '{}' as it doesn't have a mule-artifact.json", (Object)artifactName);
                    }
                    Thread.currentThread().setContextClassLoader(tccl);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading extension models", e);
        }
    }

    private List<ExtensionModel> loadRuntimeExtensionModels() {
        return new ArrayList<ExtensionModel>(RuntimeExtensionModelProviderLoaderUtils.discoverRuntimeExtensionModels());
    }
}

