/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathClassifierContext {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Artifact rootArtifact;
    private final List<URL> classPathURLs;
    private final List<String> providedExclusions = new ArrayList<String>();
    private final List<String> testExclusions = new ArrayList<String>();
    private final List<String> testInclusions = new ArrayList<String>();
    private final List<String> extraBootPackages = new ArrayList<String>();
    private final List<String> extraBootResources = new ArrayList<String>();
    private final List<String> applicationSharedLibCoordinates = new ArrayList<String>();
    private final List<String> applicationLibCoordinates = new ArrayList<String>();
    private final List<String> testRunnerExportedLibCoordinates = new ArrayList<String>();
    private final List<Class> exportPluginClasses = new ArrayList<Class>();
    private final List<String> excludedArtifacts = new ArrayList<String>();
    private final List<URL> testRunnerPluginUrls = new ArrayList<URL>();
    private boolean extensionMetadataGenerationEnabled = false;
    private final File pluginResourcesFolder;

    public ClassPathClassifierContext(Artifact rootArtifact, File pluginResourcesFolder, List<URL> classPathURLs, Set<String> excludedArtifacts, List<String> extraBootPackages, List<String> extraBootResources, Set<String> providedExclusions, Set<String> testExclusions, Set<String> testInclusions, Set<String> applicationSharedLibCoordinates, Set<Class> exportPluginClasses, List<URL> testRunnerPluginUrls, boolean extensionMetadataGenerationEnabled, Set<String> applicationLibCoordinates, Set<String> testRunnerExportedLibCoordinates) throws IOException {
        Objects.requireNonNull(rootArtifact, "rootArtifact cannot be null");
        Objects.requireNonNull(classPathURLs, "classPathURLs cannot be null");
        this.rootArtifact = rootArtifact;
        this.pluginResourcesFolder = pluginResourcesFolder;
        this.classPathURLs = classPathURLs;
        this.excludedArtifacts.addAll(excludedArtifacts);
        this.extraBootPackages.addAll(extraBootPackages);
        this.extraBootResources.addAll(extraBootResources);
        this.providedExclusions.addAll(providedExclusions);
        this.testExclusions.addAll(testExclusions);
        this.testInclusions.addAll(testInclusions);
        this.applicationLibCoordinates.addAll(applicationLibCoordinates);
        this.testRunnerExportedLibCoordinates.addAll(testRunnerExportedLibCoordinates);
        this.applicationSharedLibCoordinates.addAll(applicationSharedLibCoordinates);
        this.testRunnerPluginUrls.addAll(testRunnerPluginUrls);
        this.exportPluginClasses.addAll(exportPluginClasses);
        this.extensionMetadataGenerationEnabled = extensionMetadataGenerationEnabled;
    }

    public Artifact getRootArtifact() {
        return this.rootArtifact;
    }

    public File getPluginResourcesFolder() {
        return this.pluginResourcesFolder;
    }

    public List<URL> getClassPathURLs() {
        return this.classPathURLs;
    }

    public List<String> getProvidedExclusions() {
        return this.providedExclusions;
    }

    public List<String> getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    public List<String> getTestExclusions() {
        return this.testExclusions;
    }

    public List<String> getTestInclusions() {
        return this.testInclusions;
    }

    public List<String> getExtraBootPackages() {
        return this.extraBootPackages;
    }

    public List<String> getExtraBootResources() {
        return this.extraBootResources;
    }

    public List<Class> getExportPluginClasses() {
        return this.exportPluginClasses;
    }

    public List<String> getApplicationSharedLibCoordinates() {
        return this.applicationSharedLibCoordinates;
    }

    public List<String> getApplicationLibCoordinates() {
        return this.applicationLibCoordinates;
    }

    public List<String> getTestRunnerExportedLibCoordinates() {
        return this.testRunnerExportedLibCoordinates;
    }

    public List<URL> getTestRunnerPluginUrls() {
        return this.testRunnerPluginUrls;
    }

    public boolean isExtensionMetadataGenerationEnabled() {
        return this.extensionMetadataGenerationEnabled;
    }
}

