/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.core.SpringProperties;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class CachedIntrospectionResults {
    public static final String IGNORE_BEANINFO_PROPERTY_NAME = "spring.beaninfo.ignore";
    private static final boolean shouldIntrospectorIgnoreBeaninfoClasses = SpringProperties.getFlag("spring.beaninfo.ignore");
    private static List<BeanInfoFactory> beanInfoFactories = SpringFactoriesLoader.loadFactories(BeanInfoFactory.class, CachedIntrospectionResults.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(CachedIntrospectionResults.class);
    static final Set<ClassLoader> acceptedClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap(16));
    static final ConcurrentMap<Class<?>, CachedIntrospectionResults> strongClassCache = new ConcurrentHashMap(64);
    static final ConcurrentMap<Class<?>, CachedIntrospectionResults> softClassCache = new ConcurrentReferenceHashMap(64);
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;
    private final ConcurrentMap<PropertyDescriptor, TypeDescriptor> typeDescriptorCache;

    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            acceptedClassLoaders.add(classLoader);
        }
    }

    public static void clearClassLoader(ClassLoader classLoader) {
        Class beanClass;
        Iterator<ClassLoader> it = acceptedClassLoaders.iterator();
        while (it.hasNext()) {
            ClassLoader registeredLoader = it.next();
            if (!CachedIntrospectionResults.isUnderneathClassLoader(registeredLoader, classLoader)) continue;
            it.remove();
        }
        it = strongClassCache.keySet().iterator();
        while (it.hasNext()) {
            beanClass = (Class)((Object)it.next());
            if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
            it.remove();
        }
        it = softClassCache.keySet().iterator();
        while (it.hasNext()) {
            beanClass = (Class)((Object)it.next());
            if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
            it.remove();
        }
    }

    static CachedIntrospectionResults forClass(Class<?> beanClass) throws BeansException {
        ConcurrentMap<Class<?>, CachedIntrospectionResults> classCacheToUse;
        CachedIntrospectionResults results = (CachedIntrospectionResults)strongClassCache.get(beanClass);
        if (results != null) {
            return results;
        }
        results = (CachedIntrospectionResults)softClassCache.get(beanClass);
        if (results != null) {
            return results;
        }
        results = new CachedIntrospectionResults(beanClass);
        if (ClassUtils.isCacheSafe(beanClass, CachedIntrospectionResults.class.getClassLoader()) || CachedIntrospectionResults.isClassLoaderAccepted(beanClass.getClassLoader())) {
            classCacheToUse = strongClassCache;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not strongly caching class [" + beanClass.getName() + "] because it is not cache-safe"));
            }
            classCacheToUse = softClassCache;
        }
        CachedIntrospectionResults existing = classCacheToUse.putIfAbsent(beanClass, results);
        return existing != null ? existing : results;
    }

    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        for (ClassLoader acceptedLoader : acceptedClassLoaders) {
            if (!CachedIntrospectionResults.isUnderneathClassLoader(classLoader, acceptedLoader)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader candidate, ClassLoader parent) {
        if (candidate == parent) {
            return true;
        }
        if (candidate == null) {
            return false;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class<?> beanClass) throws BeansException {
        try {
            PropertyDescriptor[] pds;
            PropertyDescriptor[] beanInfoFactory;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Getting BeanInfo for class [" + beanClass.getName() + "]"));
            }
            BeanInfo beanInfo = null;
            Iterator<BeanInfoFactory> iterator = beanInfoFactories.iterator();
            while (iterator.hasNext() && (beanInfo = (beanInfoFactory = iterator.next()).getBeanInfo(beanClass)) == null) {
            }
            if (beanInfo == null) {
                beanInfo = shouldIntrospectorIgnoreBeaninfoClasses ? Introspector.getBeanInfo(beanClass, 3) : Introspector.getBeanInfo(beanClass);
            }
            this.beanInfo = beanInfo;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Caching PropertyDescriptors for class [" + beanClass.getName() + "]"));
            }
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds = this.beanInfo.getPropertyDescriptors()) {
                if (Class.class == beanClass && ("classLoader".equals(pd.getName()) || "protectionDomain".equals(pd.getName()))) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found bean property '" + pd.getName() + "'" + (pd.getPropertyType() != null ? " of type [" + pd.getPropertyType().getName() + "]" : "") + (pd.getPropertyEditorClass() != null ? "; editor [" + pd.getPropertyEditorClass().getName() + "]" : "")));
                }
                pd = this.buildGenericTypeAwarePropertyDescriptor(beanClass, pd);
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
            for (Class<?> clazz = beanClass; clazz != null; clazz = clazz.getSuperclass()) {
                Class<?>[] ifcs;
                for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                    PropertyDescriptor[] ifcPds;
                    BeanInfo ifcInfo = Introspector.getBeanInfo(ifc, 3);
                    for (PropertyDescriptor pd : ifcPds = ifcInfo.getPropertyDescriptors()) {
                        if (this.propertyDescriptorCache.containsKey(pd.getName())) continue;
                        pd = this.buildGenericTypeAwarePropertyDescriptor(beanClass, pd);
                        this.propertyDescriptorCache.put(pd.getName(), pd);
                    }
                }
            }
            this.typeDescriptorCache = new ConcurrentReferenceHashMap<PropertyDescriptor, TypeDescriptor>();
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to obtain BeanInfo for class [" + beanClass.getName() + "]", ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class<?> getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && StringUtils.hasLength(name) && (pd = this.propertyDescriptorCache.get(StringUtils.uncapitalize(name))) == null) {
            pd = this.propertyDescriptorCache.get(StringUtils.capitalize(name));
        }
        return pd == null || pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
    }

    PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        for (PropertyDescriptor pd : this.propertyDescriptorCache.values()) {
            pds[i] = pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
            ++i;
        }
        return pds;
    }

    private PropertyDescriptor buildGenericTypeAwarePropertyDescriptor(Class<?> beanClass, PropertyDescriptor pd) {
        try {
            return new GenericTypeAwarePropertyDescriptor(beanClass, pd.getName(), pd.getReadMethod(), pd.getWriteMethod(), pd.getPropertyEditorClass());
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to re-introspect class [" + beanClass.getName() + "]", ex);
        }
    }

    TypeDescriptor addTypeDescriptor(PropertyDescriptor pd, TypeDescriptor td) {
        TypeDescriptor existing = this.typeDescriptorCache.putIfAbsent(pd, td);
        return existing != null ? existing : td;
    }

    TypeDescriptor getTypeDescriptor(PropertyDescriptor pd) {
        return (TypeDescriptor)this.typeDescriptorCache.get(pd);
    }
}

